/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.config;

import com.vmware.vim.binding.vim.host.DateTimeInfo;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vim.host.Service;
import com.vmware.vim.binding.vim.host.ServiceInfo;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.Property;
import com.vmware.vise.data.query.type;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vsphere.client.host.util.Util;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import org.apache.commons.lang.StringUtils;

@type(value="HostSystem")
public class TimeConfigData
extends DataModel {
    private static final String SERVER_LIST_SEPARATOR = ", ";
    private static final String NTP_SERVICE_KEY = "ntpd";
    private static final String NTP_CLIENT_KEY = "ntpClient";
    private static final String NTP_STATUS_ENABLED = Util.getLocalizedString("timeConfig.ntpStatusEnabled");
    private static final String NTP_STATUS_DISABLED = Util.getLocalizedString("timeConfig.ntpStatusDisabled");
    private static final String NTP_SERVICE_STATUS_NOT_FOUND = Util.getLocalizedString("timeConfig.ntpServiceStatusNotFound");
    private static final String NTP_SERVICE_STATUS_STOPPED = Util.getLocalizedString("timeConfig.ntpServiceStatusStopped");
    private static final String NTP_SERVICE_STATUS_RUNNING = Util.getLocalizedString("timeConfig.ntpServiceStatusRunning");
    private static final String DATA_TIME_NA = Util.getLocalizedString("timeConfig.dateAndTime.NA");
    private static final String SHORT_DATE_FORMAT = "MM/dd/yyyy hh:mm aa";
    @Property(name="config.dateTimeInfo")
    public transient DateTimeInfo config;
    @Property(name="config.service")
    public transient ServiceInfo services;
    @Property(name="config.firewall")
    public transient FirewallInfo firewallInfo;
    @Property(name="currentTimeOnHost")
    public transient GregorianCalendar currentTime;
    @Property(name="timeConfig.@info")
    public TypeDescriptor info;

    private Service getNtpService() {
        if (this.services != null && this.services.service != null) {
            for (Service s : this.services.service) {
                if (!NTP_SERVICE_KEY.equals(s.key)) continue;
                return s;
            }
        }
        return null;
    }

    private Ruleset getNtpRuleset() {
        if (this.firewallInfo == null || this.firewallInfo.ruleset == null) {
            return null;
        }
        for (Ruleset rs : this.firewallInfo.ruleset) {
            if (rs.key == null || rs.key.indexOf(NTP_CLIENT_KEY) <= -1) continue;
            return rs;
        }
        return null;
    }

    public String getNtpServiceStatus() {
        Service ntpService = this.getNtpService();
        if (ntpService == null) {
            return NTP_SERVICE_STATUS_NOT_FOUND;
        }
        if (ntpService.running) {
            return NTP_SERVICE_STATUS_RUNNING;
        }
        return NTP_SERVICE_STATUS_STOPPED;
    }

    public String getNtpClientStatus() {
        Ruleset rs = this.getNtpRuleset();
        if (rs == null) {
            return NTP_STATUS_DISABLED;
        }
        if (rs.enabled) {
            return NTP_STATUS_ENABLED;
        }
        return NTP_STATUS_DISABLED;
    }

    public String getNtpServers() {
        if (this.config == null || this.config.ntpConfig == null || this.config.ntpConfig.server == null) {
            return "";
        }
        return StringUtils.join((Object[])this.config.ntpConfig.server, (String)SERVER_LIST_SEPARATOR);
    }

    public String getDateTime() {
        if (this.currentTime == null) {
            return DATA_TIME_NA;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(SHORT_DATE_FORMAT);
        return dateFormat.format(this.currentTime.getTime());
    }
}

