/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.impl;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ComputedPropertyInfo;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.DerivedPropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vsphere.client.host.util.Util;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class HostListPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String HOST_MEM_USAGE = "memoryUsage";
    private static final String HOST_CPU_USAGE = "cpuUsage";
    private static final String HOST_STATE_LABEL = "stateLabel";
    private static final String OVERALL_CPU_USAGE = "summary.quickStats.overallCpuUsage";
    private static final String NUMBER_OF_CPU_CORES = "hardware.cpuInfo.numCpuCores";
    private static final String CPU_HZ = "hardware.cpuInfo.hz";
    private static final String OVERALL_MEM_USAGE = "summary.quickStats.overallMemoryUsage";
    private static final String MEM_SIZE = "hardware.memorySize";
    private static final String CONN_STATE = "runtime.connectionState";
    private static final String MAINTENANCE_MODE = "runtime.inMaintenanceMode";
    private static final String MAINTENANCE_MODE_AS_STRING = "inMaintenanceModeString";
    private static final String POWER_STATE = "runtime.powerState";
    private final DataServiceExtensionRegistry _extensionRegistry;

    public HostListPropertyProviderAdapter(DataServiceExtensionRegistry registry) {
        this._extensionRegistry = registry;
    }

    public void initialize() {
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = HostSystem.class.getSimpleName();
        ti.properties = new String[]{HOST_MEM_USAGE, HOST_CPU_USAGE, HOST_STATE_LABEL};
        ti.computedProperties = new ComputedPropertyInfo[]{this.createComputedPropertyInfo(HOST_MEM_USAGE, new String[]{OVERALL_MEM_USAGE, MEM_SIZE}), this.createComputedPropertyInfo(HOST_CPU_USAGE, new String[]{OVERALL_CPU_USAGE, NUMBER_OF_CPU_CORES, CPU_HZ}), this.createComputedPropertyInfo(HOST_STATE_LABEL, new String[]{CONN_STATE, MAINTENANCE_MODE_AS_STRING, POWER_STATE})};
        ti.derivedProperties = new DerivedPropertyInfo[]{this.createDerivedPropertyInfo(HOST_MEM_USAGE, new String[]{OVERALL_MEM_USAGE, MEM_SIZE}), this.createDerivedPropertyInfo(HOST_CPU_USAGE, new String[]{OVERALL_CPU_USAGE, NUMBER_OF_CPU_CORES, CPU_HZ}), this.createDerivedPropertyInfo(HOST_STATE_LABEL, new String[]{CONN_STATE, MAINTENANCE_MODE, POWER_STATE})};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequest});
        Object[] objects = propertyRequest.objects;
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        PropertySpec[] properties = propertyRequest.properties;
        HashSet<String> reqPropSet = new HashSet<String>();
        for (PropertySpec propSpec : properties) {
            for (String propName : propSpec.propertyNames) {
                reqPropSet.add(propName);
            }
        }
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        for (Object obj : objects) {
            Map sourcePropertyValuesMap = (Map)sourcePropertyValues.get(obj);
            if (sourcePropertyValuesMap == null) continue;
            ResultItem resItem = new ResultItem();
            resItem.resourceObject = obj;
            PropertyValue[] computedValues = this.processResultSet(reqPropSet, sourcePropertyValuesMap, resItem.resourceObject);
            resItem.properties = computedValues;
            resultItems.add(resItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[resultItems.size()]);
        return resultSet;
    }

    private PropertyValue[] processResultSet(Set<String> reqProps, Map<String, Object> propertyValuesMap, Object resourceObject) {
        ArrayList<PropertyValue> results = new ArrayList<PropertyValue>();
        if (reqProps.contains(HOST_MEM_USAGE)) {
            this.processMemoryUsage(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(HOST_CPU_USAGE)) {
            this.processCpuUsage(propertyValuesMap, results, resourceObject);
        }
        if (reqProps.contains(HOST_STATE_LABEL)) {
            this.processStateLabel(propertyValuesMap, results, resourceObject);
        }
        return results.toArray(new PropertyValue[0]);
    }

    private void processMemoryUsage(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Number memProp;
        int overall = 0;
        long memSize = 0L;
        Number overallProp = (Number)HostListPropertyProviderAdapter.getPropertyValue(propertyValuesMap, OVERALL_MEM_USAGE);
        if (overallProp != null) {
            overall = overallProp.intValue();
        }
        if ((memProp = (Number)HostListPropertyProviderAdapter.getPropertyValue(propertyValuesMap, MEM_SIZE)) != null) {
            memSize = memProp.longValue();
        }
        if (memSize == 0L || overall == 0) {
            propValues.add(this.createPropValue(HOST_MEM_USAGE, 0, resourceObject));
            return;
        }
        BigDecimal num = new BigDecimal(overall * 100);
        BigDecimal den = new BigDecimal(memSize / 0x100000L);
        BigDecimal percent = num.divideToIntegralValue(den);
        long result = percent.longValue();
        propValues.add(this.createPropValue(HOST_MEM_USAGE, result, resourceObject));
    }

    private void processCpuUsage(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        Number cpuProp;
        Number numProp;
        int overall = 0;
        int numCpu = 0;
        long cpuhz = 0L;
        Number overallProp = (Number)HostListPropertyProviderAdapter.getPropertyValue(propertyValuesMap, OVERALL_CPU_USAGE);
        if (overallProp != null) {
            overall = overallProp.intValue();
        }
        if ((numProp = (Number)HostListPropertyProviderAdapter.getPropertyValue(propertyValuesMap, NUMBER_OF_CPU_CORES)) != null) {
            numCpu = numProp.intValue();
        }
        if ((cpuProp = (Number)HostListPropertyProviderAdapter.getPropertyValue(propertyValuesMap, CPU_HZ)) != null) {
            cpuhz = cpuProp.longValue();
        }
        if (numCpu == 0 || cpuhz == 0L) {
            propValues.add(this.createPropValue(HOST_CPU_USAGE, 0, resourceObject));
            return;
        }
        BigDecimal num = new BigDecimal(overall * 100);
        BigDecimal den = new BigDecimal((long)numCpu * cpuhz / 1000000L);
        BigDecimal percent = num.divideToIntegralValue(den);
        long result = percent.longValue();
        propValues.add(this.createPropValue(HOST_CPU_USAGE, result, resourceObject));
    }

    private void processStateLabel(Map<String, Object> propertyValuesMap, ArrayList<PropertyValue> propValues, Object resourceObject) {
        HostSystem.ConnectionState conn = (HostSystem.ConnectionState)HostListPropertyProviderAdapter.getPropertyValue(propertyValuesMap, CONN_STATE);
        Boolean maintenanceMode = (Boolean)HostListPropertyProviderAdapter.getPropertyValue(propertyValuesMap, MAINTENANCE_MODE);
        if (maintenanceMode == null) {
            maintenanceMode = Boolean.FALSE;
        }
        HostSystem.PowerState power = (HostSystem.PowerState)HostListPropertyProviderAdapter.getPropertyValue(propertyValuesMap, POWER_STATE);
        if (HostSystem.ConnectionState.disconnected.equals((Object)conn)) {
            propValues.add(this.createPropValue(HOST_STATE_LABEL, Util.getLocalizedString("hostState.disconnected"), resourceObject));
            return;
        }
        if (HostSystem.PowerState.standBy.equals((Object)power)) {
            propValues.add(this.createPropValue(HOST_STATE_LABEL, Util.getLocalizedString("hostState.standBy"), resourceObject));
            return;
        }
        if (HostSystem.ConnectionState.connected.equals((Object)conn)) {
            if (maintenanceMode.booleanValue()) {
                propValues.add(this.createPropValue(HOST_STATE_LABEL, Util.getLocalizedString("hostState.inMaintenance"), resourceObject));
                return;
            }
            propValues.add(this.createPropValue(HOST_STATE_LABEL, Util.getLocalizedString("hostState.connected"), resourceObject));
            return;
        }
        if (HostSystem.ConnectionState.notResponding.equals((Object)conn)) {
            propValues.add(this.createPropValue(HOST_STATE_LABEL, Util.getLocalizedString("hostState.notResponding"), resourceObject));
            return;
        }
        propValues.add(this.createPropValue(HOST_STATE_LABEL, "", resourceObject));
    }

    private static <T> T getPropertyValue(Map<String, Object> propertyValuesMap, String propName) {
        return (T)propertyValuesMap.get(propName);
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private ComputedPropertyInfo createComputedPropertyInfo(String propName, String[] componentProps) {
        ComputedPropertyInfo propInfo = new ComputedPropertyInfo();
        propInfo.propertyName = propName;
        propInfo.componentProperties = componentProps;
        return propInfo;
    }

    private DerivedPropertyInfo createDerivedPropertyInfo(String propName, String[] sourcePropNames) {
        DerivedPropertyInfo derivedInfo = new DerivedPropertyInfo();
        derivedInfo.propertyName = propName;
        derivedInfo.sourcePropertyNames = sourcePropNames;
        return derivedInfo;
    }
}

