/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.model;

import com.vmware.vim.binding.vim.host.CpuSchedulerSystem;
import com.vmware.vim.binding.vim.host.DnsConfig;
import com.vmware.vise.data.query.commands.DataModel;
import com.vmware.vise.data.query.commands.Property;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.host.MemoryConfigInfo;
import com.vmware.vsphere.client.host.StorageCountInfo;

@type(value="HostSystem")
public class HostHardwareData
extends DataModel {
    @Property(name="hardware.systemInfo.vendor")
    public String manufacturer;
    @Property(name="hardware.systemInfo.model")
    public String model;
    @Property(name="hardware.cpuInfo.numCpuCores")
    public int numCpuCores;
    @Property(name="summary.hardware.cpuMhz")
    public int cpuMhzCapacity;
    @Property(name="summary.quickStats.overallCpuUsage")
    public long cpuMhzUsage;
    @Property(name="hardware.memorySize")
    public long memorySize;
    @Property(name="summary.quickStats.overallMemoryUsage")
    public int memoryUsage;
    @Property(name="summary.hardware.cpuModel")
    public String cpuModel;
    @Property(name="hardware.cpuInfo.numCpuPackages")
    public int sockets;
    @Property(name="hardware.cpuInfo.numCpuThreads")
    public int logicalCpu;
    @Property(name="summary.hardware.numHBAs")
    public int numHBAs;
    @Property(name="summary.hardware.numNics")
    public int numNics;
    @Property(name="allNetwork._length")
    public int networkCount;
    @Property(name="datastore._length")
    public int datastoreCount;
    @Property(name="storageCountInfo")
    public StorageCountInfo storageCountInfo;
    @Property(name="dnsConfig")
    public DnsConfig dnsConfig;
    @Property(name="memoryConfigInfo")
    public MemoryConfigInfo memoryConfig;
    @Property(name="hyperthreadingInfo")
    public CpuSchedulerSystem.HyperThreadScheduleInfo hyperthreadingInfo;
    @Property(name="capability.vFlashSupported")
    public boolean isVFlashSupported;
    @Property(name="runtime.vFlashResourceRuntimeInfo.capacity")
    public transient long vFlashResourceCapacity;
    @Property(name="runtime.vFlashResourceRuntimeInfo.usage")
    public transient long vFlashResourceUsage;

    public String getvFlashResourceCapacityText() {
        return HostHardwareData.formatDataSize(new Long(this.vFlashResourceCapacity), 1L);
    }

    public String getvFlashResourceUsageText() {
        return HostHardwareData.formatDataSize(new Long(this.vFlashResourceUsage), 1L);
    }

    public String getvFlashResourceFreeText() {
        return HostHardwareData.formatDataSize(new Long(this.vFlashResourceCapacity - this.vFlashResourceUsage), 1L);
    }

    public String getCpuMhzCapacityText() {
        return FormatUtil.getFrequencyFormatted((Number)new Integer(this.cpuMhzCapacity), (int)2, (long)FormatUtil.MHz, (long)-1L, (boolean)true);
    }

    public String getCpuUsagePercentage() {
        return String.format("%.0f", Float.valueOf((float)this.cpuMhzUsage * 100.0f / ((float)this.cpuMhzCapacity * (float)this.numCpuCores)));
    }

    public String getMemoryUsageText() {
        return HostHardwareData.formatDataSize(new Long(this.memoryUsage), 0x100000L);
    }

    public String getMemoryUsagePercentage() {
        return String.format("%.0f", Float.valueOf((float)this.memoryUsage * 1024.0f * 1024.0f * 100.0f / (float)this.memorySize));
    }

    public String getMemorySizeText() {
        return HostHardwareData.formatDataSize(new Long(this.memorySize), 1L);
    }

    private static String formatDataSize(Number bytes, long base) {
        return FormatUtil.getDataSizeFormatted((Number)bytes, (int)2, (long)base, (long)-1L, (boolean)true);
    }
}

