/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.host.powerops;

import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.host.impl.HostMutationProvider;
import com.vmware.vsphere.client.host.powerops.HostPowerSpec;
import com.vmware.vsphere.client.host.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HostPowerOpManager {
    private static final Log _logger = LogFactory.getLog(HostMutationProvider.class);

    public static OperationResult applyPowerOp(ManagedObjectReference hostRef, HostPowerSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = hostRef;
        try {
            EventManager eventManager = Util.getEventManager(hostRef);
            eventManager.logUserEvent(hostRef, spec.reason);
            HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
            result = HostPowerOpManager.applyPowerOp(host, spec, result);
        }
        catch (Exception ex) {
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private static OperationResult applyPowerOp(HostSystem host, HostPowerSpec spec, OperationResult result) {
        try {
            if (spec.powerOpType == HostPowerSpec.PowerOpType.reboot) {
                result.task = host.reboot(spec.force);
            }
            if (spec.powerOpType == HostPowerSpec.PowerOpType.shutdown) {
                result.task = host.shutdown(spec.force);
            }
            result.effect = OperationEffect.newDelayedEffect();
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }
}

