/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client;

import com.vmware.vim.sso.client.GssNegotiationClient;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SsoAsyncHandler;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.exception.CertificateValidationException;
import com.vmware.vim.sso.client.exception.InternalError;
import com.vmware.vim.sso.client.exception.InvalidTokenException;
import com.vmware.vim.sso.client.exception.RequestExpiredException;
import com.vmware.vim.sso.client.exception.ServerCommunicationException;
import com.vmware.vim.sso.client.exception.ServerSecurityException;
import com.vmware.vim.sso.client.exception.TimeSynchronizationException;
import com.vmware.vim.sso.client.exception.TokenRequestRejectedException;
import java.util.concurrent.Future;

public interface SecurityTokenService {
    public SamlToken acquireToken(String var1, String var2, TokenSpec var3) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException;

    public Future<SamlToken> acquireTokenAsync(String var1, String var2, TokenSpec var3, SsoAsyncHandler<SamlToken> var4);

    public Future<SamlToken> acquireTokenAsync(String var1, String var2, TokenSpec var3);

    public SamlToken acquireTokenByGSS(TokenSpec var1, NegotiationHandler var2) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException;

    public Future<SamlToken> acquireTokenByGSSAsync(TokenSpec var1, NegotiationHandler var2, SsoAsyncHandler<SamlToken> var3);

    public Future<SamlToken> acquireTokenByGSSAsync(TokenSpec var1, NegotiationHandler var2);

    public GssNegotiationClient obtainGssNegotiationClient(TokenSpec var1);

    public SamlToken acquireTokenByCertificate(TokenSpec var1) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException;

    public Future<SamlToken> acquireTokenByCertificateAsync(TokenSpec var1, SsoAsyncHandler<SamlToken> var2);

    public Future<SamlToken> acquireTokenByCertificateAsync(TokenSpec var1);

    public SamlToken acquireTokenByToken(SamlToken var1, TokenSpec var2) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException;

    public Future<SamlToken> acquireTokenByTokenAsync(SamlToken var1, TokenSpec var2, SsoAsyncHandler<SamlToken> var3);

    public Future<SamlToken> acquireTokenByTokenAsync(SamlToken var1, TokenSpec var2);

    public boolean validateToken(SamlToken var1) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException;

    public Future<Boolean> validateTokenAsync(SamlToken var1, SsoAsyncHandler<Boolean> var2);

    public Future<Boolean> validateTokenAsync(SamlToken var1);

    public SamlToken renewToken(SamlToken var1, long var2) throws InvalidTokenException, TokenRequestRejectedException, InternalError, ServerCommunicationException, ServerSecurityException, RequestExpiredException, CertificateValidationException, TimeSynchronizationException;

    public Future<SamlToken> renewTokenAsync(SamlToken var1, long var2, SsoAsyncHandler<SamlToken> var4);

    public Future<SamlToken> renewTokenAsync(SamlToken var1, long var2);

    public static interface NegotiationHandler {
        public byte[] negotiate(byte[] var1);
    }
}

