/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.sso.client.impl.processors.request;

import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vim.sso.client.SecurityTokenServiceConfig;
import com.vmware.vim.sso.client.TokenSpec;
import com.vmware.vim.sso.client.impl.RequestBuilder;
import com.vmware.vim.sso.client.impl.RequestBuilderFactory;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenByCertificateRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenByTokenRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.AcquireTokenByUserPassRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.ContinueAcquireTokenByGssRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.InitiateAcquireTokenByGssRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.RenewTokenRequestBuilder;
import com.vmware.vim.sso.client.impl.processors.request.ValidateTokenRequestBuilder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class DefaultRequestBuilderFactory
implements RequestBuilderFactory {
    private static final String WSSE_JAXB_PACKAGE = "org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0";
    private static final String WSSU_JAXB_PACKAGE = "org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0";
    private final boolean _hokConfirmation;
    private final int _requestValidityInSeconds;
    private final JAXBContext _jaxbContext;

    public DefaultRequestBuilderFactory(SecurityTokenServiceConfig config) {
        try {
            this._jaxbContext = JAXBContext.newInstance((String)"org.oasis_open.docs.ws_sx.ws_trust._200802:org.oasis_open.docs.ws_sx.ws_trust._200512:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_secext_1_0:org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0");
        }
        catch (JAXBException e) {
            throw new IllegalStateException("JAXBContext cannot be initialized", e);
        }
        this._hokConfirmation = config.getHolderOfKeyConfig() != null;
        this._requestValidityInSeconds = config.getRequestValidityInSeconds();
    }

    @Override
    public RequestBuilder getAcquireTokenByTokenBuilder(SamlToken token, TokenSpec tokenSpec) {
        return new AcquireTokenByTokenRequestBuilder(token, tokenSpec, this._hokConfirmation, this._jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getAcquireTokenByCertificateBuilder(TokenSpec tokenSpec) {
        assert (this._hokConfirmation);
        return new AcquireTokenByCertificateRequestBuilder(tokenSpec, this._jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getAcquireTokenByUserPassBuilder(String subject, String password, TokenSpec spec) {
        return new AcquireTokenByUserPassRequestBuilder(subject, password, spec, this._hokConfirmation, this._jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getContinueAcquireTokenByGssBuilder(String contextId, byte[] leg) {
        return new ContinueAcquireTokenByGssRequestBuilder(contextId, leg, this._jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getInitialAcquireTokenByGssBuilder(TokenSpec tokenSpec, byte[] initialLeg) {
        return new InitiateAcquireTokenByGssRequestBuilder(tokenSpec, initialLeg, this._hokConfirmation, this._jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getRenewTokenBuilder(SamlToken token, long tokenLifetimeSec) {
        return new RenewTokenRequestBuilder(token, tokenLifetimeSec, this._jaxbContext, this._requestValidityInSeconds);
    }

    @Override
    public RequestBuilder getValidateTokenBuilder(SamlToken token) {
        return new ValidateTokenRequestBuilder(token, this._jaxbContext, this._requestValidityInSeconds);
    }
}

