/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;

public class MetadataTagCheckerPropertyTester
extends PropertyTester {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (property.equals("asproject")) {
            return this.checkAsProject(receiver);
        }
        if (!property.equals("ngcproject")) {
            if (!property.equals("enabled")) return false;
            if (args.length <= 0) return false;
            Boolean arg = (Boolean)args[0];
            if (arg == false) return false;
            return true;
        }
        if (!(receiver instanceof IResource)) return false;
        IResource res = (IResource)receiver;
        IProject project = res.getProject();
        try {
            IProjectDescription desc = project.getDescription();
            String[] stringArray = desc.getNatureIds();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                String nature = stringArray[n2];
                if (nature.equals("org.eclipse.jdt.core.javanature")) return true;
                if (nature.endsWith("actionscriptnature")) {
                    return true;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean checkAsProject(Object receiver) {
        if (receiver instanceof IFolder || receiver instanceof IProject) {
            IResource res = (IResource)receiver;
            final boolean[] found = new boolean[1];
            try {
                res.accept(new IResourceVisitor(){

                    public boolean visit(IResource resource) throws CoreException {
                        IFile f;
                        if (resource instanceof IFile && "as".equals((f = (IFile)resource).getFileExtension())) {
                            found[0] = true;
                            return false;
                        }
                        return true;
                    }
                });
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            return found[0];
        }
        if (receiver instanceof IFile) {
            IFile file = (IFile)receiver;
            return "as".equals(file.getFileExtension());
        }
        return false;
    }
}

