/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.as.parser;

import com.vmware.vide.vwcsdktools.as.parser.Keyword;
import com.vmware.vide.vwcsdktools.as.parser.KeywordToken;
import com.vmware.vide.vwcsdktools.as.parser.MultiLineToken;
import com.vmware.vide.vwcsdktools.as.parser.TokenKind;

public class AsToken {
    private final int startLine;
    private final int startColumn;
    private final int length;
    private TokenKind kind;

    private AsToken(int line, int column, int len) {
        this.startLine = line;
        this.startColumn = column;
        this.length = len;
    }

    AsToken(int line, int column, int len, TokenKind kind) {
        this(line, column, len);
        this.kind = kind;
    }

    void setKind(TokenKind kind) {
        this.kind = kind;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isIdentifier() {
        return this.kind == TokenKind.IDENTIFIER;
    }

    public boolean isNumberLiteral() {
        return this.kind == TokenKind.NUMBER_LITERAL;
    }

    public boolean isRightParenthesis() {
        return this.kind == TokenKind.RIGHT_PARENTHESIS;
    }

    public boolean isRightBrace() {
        return this.kind == TokenKind.RIGHT_BRACE;
    }

    public boolean isRightBracket() {
        return this.kind == TokenKind.RIGHT_BRACKET;
    }

    public boolean isNewLine() {
        return this.kind == TokenKind.EOL_SEPARATOR;
    }

    public boolean isKeyword() {
        return this.kind == TokenKind.KEYWORD;
    }

    public boolean isComment() {
        return this.kind == TokenKind.COMMENT;
    }

    public boolean isLeftBracket() {
        return this.kind == TokenKind.LEFT_BRACKET;
    }

    boolean isEmtpyToken() {
        return this.kind == TokenKind.EMPTY;
    }

    public boolean isEof() {
        return this.kind == TokenKind.EOF;
    }

    public boolean isMetadataStart() {
        return this.kind == TokenKind.METADATA_START;
    }

    public boolean isMetadataEnd() {
        return this.kind == TokenKind.METADATA_END;
    }

    TokenKind getKind() {
        return this.kind;
    }

    public void dump() {
        System.out.println(String.format("Line:%4d Column:%3d  %s", this.startLine, this.startColumn, this.kind.name()));
    }

    public String toString() {
        return this.kind.getSymbol();
    }

    public boolean isEolSeparator() {
        return this.kind == TokenKind.EOL_SEPARATOR;
    }

    public boolean isDot() {
        return this.kind == TokenKind.DOT;
    }

    public boolean isStringLiteral() {
        return this.kind == TokenKind.STRING_LITERAL;
    }

    public boolean isLeftParenthesis() {
        return this.kind == TokenKind.LEFT_PARENTHESIS;
    }

    public boolean isEqual() {
        return this.kind == TokenKind.EQUAL;
    }

    public boolean isComma() {
        return this.kind == TokenKind.COMMA;
    }

    public boolean isLeftBrace() {
        return this.kind == TokenKind.LEFT_BRACE;
    }

    public boolean isMultiLine() {
        return this instanceof MultiLineToken;
    }

    public boolean isValueKeyword() {
        Keyword key;
        return this.kind == TokenKind.KEYWORD && ((key = ((KeywordToken)this).keyword) == Keyword.FALSE || key == Keyword.TRUE);
    }
}

