/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vwcsdktools.managers;

import com.vmware.vide.vwcsdktools.Activator;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataCheckerFactory;
import com.vmware.vide.vwcsdktools.as.checkers.MetadataTagChecker;
import com.vmware.vide.vwcsdktools.as.model.MetadataTag;
import com.vmware.vide.vwcsdktools.as.model.MetadataTagParameter;
import com.vmware.vide.vwcsdktools.managers.CheckRule;
import com.vmware.vide.vwcsdktools.managers.CheckRuleManager;
import com.vmware.vide.vwcsdktools.managers.CheckTypeRule;
import com.vmware.vide.vwcsdktools.managers.DiagnosticLevel;
import com.vmware.vide.vwcsdktools.managers.ParameterRule;
import com.vmware.vide.vwcsdktools.processors.CheckType;
import com.vmware.vide.vwcsdktools.utils.Property;
import com.vmware.vide.vwcsdktools.utils.WhiteListUtil;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListItem;
import com.vmware.vide.vwcsdktools.whitelist.WhiteListManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;

public enum MetadataTagProjectDataManager {
    INSTANCE;

    public static final String USE_PROJECT_SETTINGS_FOR_METADATA_TAG_CHECKER = "metadata-tag-checker-use-project-settings";
    public static final String RUN_METADATA_TAG_CHECKER_AT_SAVE = "run-metadata-tag-checker-at-save";
    private static ILog logger;
    private Map<String, Map<String, List<CheckTypeRule>>> workspaceCheckRuleTable;
    private final Map<IProject, Map<String, Map<String, List<CheckTypeRule>>>> projectCheckRuleTables = new HashMap<IProject, Map<String, Map<String, List<CheckTypeRule>>>>();
    private final Map<String, Set<String>> workspaceWhiteLists = new LinkedHashMap<String, Set<String>>();
    private final Map<IProject, Map<String, Set<String>>> projectWhiteListsTable = new HashMap<IProject, Map<String, Set<String>>>();

    static {
        logger = Activator.getDefault().getLog();
    }

    private MetadataTagProjectDataManager() {
        this.init();
    }

    private void init() {
        List<CheckRule> rules = CheckRuleManager.METADATA_TAG_INSTANCE.getRules();
        if (rules == null) {
            this.workspaceCheckRuleTable = new LinkedHashMap<String, Map<String, List<CheckTypeRule>>>();
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", "Failed to get metadata tag check rules."));
            return;
        }
        this.workspaceCheckRuleTable = this.createCheckRuleTable(rules);
        List<WhiteListItem> wLists = WhiteListManager.METADATA_TAG_INSTANCE.getWorkspaceWhiteList();
        if (wLists == null) {
            logger.log((IStatus)new Status(4, "com.vmware.vide.vwcsdktools", "Failed to get metadata tag white lists."));
            return;
        }
        this.transferWhiteListsToTable(wLists, this.workspaceWhiteLists);
    }

    private void transferWhiteListsToTable(List<WhiteListItem> whiteLists, Map<String, Set<String>> table) {
        for (WhiteListItem list : whiteLists) {
            LinkedHashSet<String> words = new LinkedHashSet<String>();
            for (String word : list.getList()) {
                words.add(word);
            }
            table.put(list.getName(), words);
        }
    }

    private Map<String, Map<String, List<CheckTypeRule>>> createCheckRuleTable(List<CheckRule> rules) {
        LinkedHashMap<String, Map<String, List<CheckTypeRule>>> newRules = new LinkedHashMap<String, Map<String, List<CheckTypeRule>>>();
        for (CheckRule rule : rules) {
            String tagName = rule.getName();
            LinkedHashMap<String, List> paramRules = new LinkedHashMap<String, List>();
            for (ParameterRule paramRule : rule.getParameterRules()) {
                String paramName = paramRule.getName();
                List<CheckTypeRule> checkTypeRules = paramRule.getCheckTypes();
                List newCheckTypeRules = (List)((ArrayList)checkTypeRules).clone();
                paramRules.put(paramName, newCheckTypeRules);
            }
            newRules.put(tagName, paramRules);
        }
        return newRules;
    }

    private Map<String, Map<String, List<CheckTypeRule>>> cloneCheckRuleTable(Map<String, Map<String, List<CheckTypeRule>>> org) {
        LinkedHashMap<String, Map<String, List<CheckTypeRule>>> newRules = new LinkedHashMap<String, Map<String, List<CheckTypeRule>>>();
        for (Map.Entry<String, Map<String, List<CheckTypeRule>>> entry : org.entrySet()) {
            String tagName = entry.getKey();
            entry.getValue().keySet();
            LinkedHashMap<String, List> paramRules = new LinkedHashMap<String, List>();
            for (String paramName : entry.getValue().keySet()) {
                List<CheckTypeRule> rules = entry.getValue().get(paramName);
                List newTypeRules = (List)((ArrayList)rules).clone();
                paramRules.put(paramName, newTypeRules);
            }
            newRules.put(tagName, paramRules);
        }
        return newRules;
    }

    public List<MetadataTagChecker> getTagCheckers(IFile file, MetadataTag tag) {
        return new ArrayList<MetadataTagChecker>();
    }

    public List<MetadataTagChecker> getParameterCheckers(IFile file, MetadataTag tag, MetadataTagParameter parameter) {
        ArrayList<MetadataTagChecker> checkers = new ArrayList<MetadataTagChecker>();
        IProject project = file.getProject();
        Map<String, Map<String, List<CheckTypeRule>>> table = this.getProjectCheckRuleTable(project);
        Map<String, List<CheckTypeRule>> paramTable = table.get(tag.getName());
        if (paramTable != null && paramTable.containsKey(parameter.getParameterName())) {
            List<CheckTypeRule> rules = table.get(tag.getName()).get(parameter.getParameterName());
            for (CheckTypeRule rule : rules) {
                MetadataTagChecker checker = MetadataCheckerFactory.INSTANCE.createChecker(rule, file, tag, parameter);
                if (checker == null) continue;
                checkers.add(checker);
            }
        }
        return checkers;
    }

    private boolean useProjectSettings(IProject project) {
        return Property.getBoolean((IResource)project, USE_PROJECT_SETTINGS_FOR_METADATA_TAG_CHECKER);
    }

    private Map<String, Map<String, List<CheckTypeRule>>> _getProjectCheckRuleTable(IProject project) {
        if (this.projectCheckRuleTables.containsKey(project)) {
            return this.projectCheckRuleTables.get(project);
        }
        Map<String, Map<String, List<CheckTypeRule>>> table = this.cloneCheckRuleTable(this.getWorkspaceCheckRuleTable());
        this.projectCheckRuleTables.put(project, table);
        return table;
    }

    public Map<String, Map<String, List<CheckTypeRule>>> getProjectCheckRuleTable(IProject project) {
        if (this.useProjectSettings(project)) {
            return this._getProjectCheckRuleTable(project);
        }
        return this.getWorkspaceCheckRuleTable();
    }

    public Map<String, Map<String, List<CheckTypeRule>>> getWorkspaceCheckRuleTable() {
        return this.workspaceCheckRuleTable;
    }

    private Set<String> getWorkspaceWhiteList(String whiteListName) {
        return this.workspaceWhiteLists.get(whiteListName);
    }

    private Map<String, Set<String>> cloneWhiteLists(Map<String, Set<String>> orig) {
        LinkedHashMap<String, Set<String>> newLists = new LinkedHashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : orig.entrySet()) {
            newLists.put(entry.getKey(), new LinkedHashSet(entry.getValue()));
        }
        return newLists;
    }

    public Map<String, Set<String>> getProjectWhiteLists(IProject project) {
        List<WhiteListItem> lists;
        if (this.projectWhiteListsTable.containsKey(project)) {
            return this.projectWhiteListsTable.get(project);
        }
        if (WhiteListManager.METADATA_TAG_INSTANCE.projectWhiteListFileExists(project) && (lists = WhiteListManager.METADATA_TAG_INSTANCE.loadProjectWhiteListFile(project)) != null) {
            LinkedHashMap<String, Set<String>> table = new LinkedHashMap<String, Set<String>>();
            this.transferWhiteListsToTable(lists, table);
            this.projectWhiteListsTable.put(project, table);
            return table;
        }
        Map<String, Set<String>> whiteLists = this.cloneWhiteLists(this.workspaceWhiteLists);
        this.projectWhiteListsTable.put(project, whiteLists);
        return whiteLists;
    }

    private Set<String> _getProjectWhiteList(IProject project, String whiteListName) {
        return this.getProjectWhiteLists(project).get(whiteListName);
    }

    public Set<String> getWhiteList(IProject project, String whiteListName) {
        if (this.useProjectSettings(project)) {
            return this._getProjectWhiteList(project, whiteListName);
        }
        return this.getWorkspaceWhiteList(whiteListName);
    }

    private DiagnosticLevel getProjectDiagnosticLevel(IProject project, String tag, String param, CheckType checkType) {
        List<CheckTypeRule> rules = this._getProjectCheckRuleTable(project).get(tag).get(param);
        for (CheckTypeRule rule : rules) {
            if (rule.type != checkType) continue;
            return rule.level;
        }
        return DiagnosticLevel.ERROR;
    }

    private DiagnosticLevel getWorkspaceDiagnosticLevel(String tag, String param, CheckType checkType) {
        List<CheckTypeRule> rules = this.getWorkspaceCheckRuleTable().get(tag).get(param);
        for (CheckTypeRule rule : rules) {
            if (rule.type != checkType) continue;
            return rule.level;
        }
        return DiagnosticLevel.ERROR;
    }

    public DiagnosticLevel getDiagnosticLevel(IFile file, String tag, String param, CheckType checkType) {
        IProject project = file.getProject();
        if (this.useProjectSettings(project)) {
            this.getProjectDiagnosticLevel(project, tag, param, checkType);
        }
        return this.getWorkspaceDiagnosticLevel(tag, param, checkType);
    }

    private void addWordWorkspaceWhiteList(String whiteListName, String word) {
        Set<String> list = this.getWorkspaceWhiteList(whiteListName);
        if (list != null) {
            list.add(word);
        }
    }

    private void addWordProjectWhiteList(IProject project, String whiteListName, String word) {
        Set<String> list = this._getProjectWhiteList(project, whiteListName);
        if (list != null) {
            list.add(word);
        }
    }

    public void addWordToWhiteListFile(IFile file, String whiteListName, String word) {
        IProject project = file.getProject();
        if (this.useProjectSettings(project)) {
            Set<String> list = this._getProjectWhiteList(project, whiteListName);
            if (list == null) {
                return;
            }
            if (list.contains(word)) {
                return;
            }
            this.addWordProjectWhiteList(project, whiteListName, word);
            this.updateProjectWhiteListFile(project);
            return;
        }
        Set<String> list = this.getWorkspaceWhiteList(whiteListName);
        if (list == null) {
            return;
        }
        if (list.contains(word)) {
            return;
        }
        this.addWordWorkspaceWhiteList(whiteListName, word);
        this.updateWorkspaceWhiteListFile();
    }

    private void updateProjectWhiteListFile(IProject project) {
        Map<String, Set<String>> lists = this.getProjectWhiteLists(project);
        WhiteListManager.METADATA_TAG_INSTANCE.writeToProjectWhiteListFile(project, lists);
    }

    private void updateWorkspaceWhiteListFile() {
        WhiteListManager.METADATA_TAG_INSTANCE.writeToWorkspaceWhiteListFile(this.workspaceWhiteLists);
    }

    public boolean runCheckerAtSave(IProject project) {
        if (this.useProjectSettings(project)) {
            return Property.getBoolean((IResource)project, RUN_METADATA_TAG_CHECKER_AT_SAVE, true);
        }
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        return store.getBoolean("com.vmware.vide.vwcsdktools.run-metadata-tag-checker-at-save");
    }

    public Map<String, Set<String>> getWorkspaceWhiteLists() {
        return this.workspaceWhiteLists;
    }

    public void updateWorkspaceWhiteListTable(Map<String, Set<String>> whiteLists) {
        this.updateWhiteListTable(this.workspaceWhiteLists, whiteLists);
        this.updateWorkspaceWhiteListFile();
    }

    public void updateProjectWhiteListTable(IProject project, Map<String, Set<String>> whiteLists) {
        Map<String, Set<String>> table = this.getProjectWhiteLists(project);
        this.updateWhiteListTable(table, whiteLists);
        this.updateProjectWhiteListFile(project);
    }

    private void updateWhiteListTable(Map<String, Set<String>> oldLists, Map<String, Set<String>> newLists) {
        for (Map.Entry<String, Set<String>> entry : oldLists.entrySet()) {
            if (newLists.containsKey(entry.getKey())) {
                entry.getValue().clear();
                if (newLists.get(entry.getKey()) == null) continue;
                entry.getValue().addAll((Collection<String>)newLists.get(entry.getKey()));
                continue;
            }
            oldLists.remove(entry.getKey());
        }
    }

    public Map<String, Set<String>> cloneWorkspaceWhiteLists() {
        return this.cloneWhiteLists(this.workspaceWhiteLists);
    }

    public Map<String, Set<String>> cloneProjectWhiteLists(IProject project) {
        return this.cloneWhiteLists(this.getProjectWhiteLists(project));
    }

    public Set<String> getWhiteListWords(List<IFile> files, String whiteListName) {
        Map<String, Map<String, List<CheckTypeRule>>> table = this.getWorkspaceCheckRuleTable();
        return WhiteListUtil.getWhiteListWords(files, whiteListName, table);
    }

    public Set<String> getWhiteListWords(IProject project, List<IFile> files, String whiteListName) {
        Map<String, Map<String, List<CheckTypeRule>>> table = this.getProjectCheckRuleTable(project);
        return WhiteListUtil.getWhiteListWords(files, whiteListName, table);
    }
}

