/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.cache.impl;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.CacheInvalidateCallback;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class FifoCacheImpl<K, V>
implements Cache<K, V> {
    private final ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final FifoTable<K, V> _table;
    private final CacheInvalidateCallback<V> _invalidateCallback;

    public FifoCacheImpl(int capacity) {
        this(capacity, null);
    }

    public FifoCacheImpl(int capacity, CacheInvalidateCallback<V> invalidateCallback) {
        this._table = new FifoTable(capacity);
        this._invalidateCallback = invalidateCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(K key, V value) {
        this._rwLock.writeLock().lock();
        try {
            this._table.put(key, value);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key) {
        this._rwLock.readLock().lock();
        try {
            Object v = this._table.get(key);
            return v;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(K key) {
        this._rwLock.readLock().lock();
        try {
            boolean bl = this._table.containsKey(key);
            return bl;
        }
        finally {
            this._rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate(K key) {
        Object value = null;
        this._rwLock.writeLock().lock();
        try {
            value = this._table.remove(key);
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
        if (this._invalidateCallback != null && value != null) {
            this._invalidateCallback.cacheValueInvalidated(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidate() {
        ArrayList valuesCopy = null;
        this._rwLock.writeLock().lock();
        try {
            if (this._invalidateCallback != null) {
                valuesCopy = new ArrayList(this._table.values());
            }
            this._table.clear();
        }
        finally {
            this._rwLock.writeLock().unlock();
        }
        if (this._invalidateCallback != null && valuesCopy != null) {
            for (Object value : valuesCopy) {
                this._invalidateCallback.cacheValueInvalidated(value);
            }
        }
    }

    private static class FifoTable<K, V>
    extends LinkedHashMap<K, V> {
        private static final long serialVersionUID = 1L;
        private final int _capacity;

        public FifoTable(int capacity) {
            super(capacity + 1, 0.75f, false);
            this._capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this._capacity;
        }
    }
}

