/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.domain;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.LruCacheImpl;
import com.vmware.vim.binding.cis.license.Product;
import com.vmware.vim.binding.cis.license.ProductFamily;
import com.vmware.vim.binding.impl.cis.license.ProductFamilyImpl;
import com.vmware.vim.binding.impl.cis.license.ProductImpl;

public class ProductUtil {
    public static final String UNLICENSED_ID = "Unlicensed";
    public static final String UNLICENSED_NAME = "Unlicensed";
    public static final String UNLICENSED_EDITION_KEY = "Unlicensed";
    public static final String ERROR_LICENSE_DECODE_FAILED_ID = "DecodeError";
    public static final String ERROR_LICENSE_DECODE_FAILED_NAME = "DecodeError";
    public static final String ERROR_LICENSE_DECODE_FAILED_EDITION_KEY = "DecodeError";
    public static final String ERROR_LICENSE_NOT_FOUND_ID = "NotFoundError";
    public static final String ERROR_LICENSE_NOT_FOUND_NAME = "NotFoundError";
    public static final String ERROR_LICENSE_NOT_FOUND_EDITION_KEY = "NotFoundError";
    public static final String ERROR_PRODUCT_FAMILY_NAME = "Error";
    public static final String ERROR_PRODUCT_FAMILY_VERSION = "0.0";
    private static final Cache<String, ProductImpl> _productIdToProductCache = new LruCacheImpl<String, ProductImpl>(30);
    private static final Cache<Integer, ProductFamilyImpl> _productFamilyIdToProductFamilyCache = new LruCacheImpl<Integer, ProductFamilyImpl>(10);
    private static final Cache<Integer, ProductImpl> _productFamilyIdToUnlicensedProductCache = new LruCacheImpl<Integer, ProductImpl>(10);
    private static final Cache<Integer, ProductImpl> _productFamilyIdToDecodeErrorProductCache = new LruCacheImpl<Integer, ProductImpl>(10);
    private static final Cache<Integer, ProductImpl> _productFamilyIdToNotFoundProductCache = new LruCacheImpl<Integer, ProductImpl>(10);

    public static boolean isDecodeErrorProduct(Product product) {
        return "DecodeError".equals(product.getId());
    }

    public static boolean isNotFoundErrorProduct(Product product) {
        return "NotFoundError".equals(product.getId());
    }

    public static Product createProductForLicenseDecodeError() {
        return ProductUtil.createProduct("DecodeError", ERROR_PRODUCT_FAMILY_NAME, ERROR_PRODUCT_FAMILY_VERSION, null, "DecodeError", "DecodeError");
    }

    public static Product createProductForLicenseNotFoundError() {
        return ProductUtil.createProduct("NotFoundError", ERROR_PRODUCT_FAMILY_NAME, ERROR_PRODUCT_FAMILY_VERSION, null, "NotFoundError", "NotFoundError");
    }

    public static Product createProductForLicenseDecodeError(ProductFamily productFamily) {
        int productFamilyId = ProductUtil.getProductFamilyId(productFamily.getName(), productFamily.getVersion());
        ProductImpl product = _productFamilyIdToDecodeErrorProductCache.get(productFamilyId);
        if (product == null) {
            product = new ProductImpl("DecodeError", "DecodeError", null, "DecodeError", productFamily);
            _productFamilyIdToDecodeErrorProductCache.put(productFamilyId, product);
        }
        return product;
    }

    public static Product createProductForLicenseNotFoundError(ProductFamily productFamily) {
        int productFamilyId = ProductUtil.getProductFamilyId(productFamily.getName(), productFamily.getVersion());
        ProductImpl product = _productFamilyIdToNotFoundProductCache.get(productFamilyId);
        if (product == null) {
            product = new ProductImpl("NotFoundError", "NotFoundError", null, "NotFoundError", productFamily);
            _productFamilyIdToNotFoundProductCache.put(productFamilyId, product);
        }
        return product;
    }

    public static Product createProduct(String productId, String productFamilyName, String productFamilyVersion, String productSuiteName, String productName, String editionKey) {
        ProductImpl product = _productIdToProductCache.get(productId);
        if (product == null) {
            ProductFamily productFamily = ProductUtil.createProductFamily(productFamilyName, productFamilyVersion);
            product = new ProductImpl(productId, productName, productSuiteName, editionKey, productFamily);
            _productIdToProductCache.put(productId, product);
        }
        return product;
    }

    public static Product createUnlicensedProduct(ProductFamily productFamily) {
        int productFamilyId = ProductUtil.getProductFamilyId(productFamily.getName(), productFamily.getVersion());
        ProductImpl product = _productFamilyIdToUnlicensedProductCache.get(productFamilyId);
        if (product == null) {
            product = new ProductImpl("Unlicensed", "Unlicensed", null, "Unlicensed", productFamily);
            _productFamilyIdToUnlicensedProductCache.put(productFamilyId, product);
        }
        return product;
    }

    public static ProductFamily createProductFamily(String name, String version) {
        int productFamilyId = ProductUtil.getProductFamilyId(name, version);
        ProductFamilyImpl productFamily = _productFamilyIdToProductFamilyCache.get(productFamilyId);
        if (productFamily == null) {
            productFamily = new ProductFamilyImpl(name, version);
            _productFamilyIdToProductFamilyCache.put(productFamilyId, productFamily);
        }
        return productFamily;
    }

    public static boolean areProductFamiliesEqual(ProductFamily source, ProductFamily target) {
        if (source == null || target == null) {
            return false;
        }
        return source.getName().equals(target.getName()) && source.getVersion().equals(target.getVersion());
    }

    private static int getProductFamilyId(String productFamilyName, String productFamilyVersion) {
        int productFamilyId = productFamilyName.hashCode() * 31 + productFamilyVersion.hashCode();
        return productFamilyId;
    }
}

