/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.ft.impl;

import com.vmware.cis.license.common.ft.Operation;
import com.vmware.cis.license.common.ft.RetryStrategy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RetryOperationImpl<T>
implements Operation<T> {
    private static final Log _log = LogFactory.getLog(RetryOperationImpl.class);
    private final RetryStrategy _retryStrategy;
    private final Operation<T> _operation;
    private Operation<T> _retryOperation;

    public RetryOperationImpl(RetryStrategy retryStrategy, Operation<T> operation) {
        this._retryStrategy = retryStrategy;
        this._operation = operation;
    }

    public RetryOperationImpl(RetryStrategy retryStrategy, Operation<T> operation, Operation<T> retryOperation) {
        this(retryStrategy, operation);
        this._retryOperation = retryOperation;
    }

    @Override
    public T execute() throws Exception {
        boolean shouldRetryOperation;
        T result = null;
        Exception lastError = null;
        int retryAttempt = 0;
        do {
            try {
                Operation<T> op = this._operation;
                if (retryAttempt > 0 && this._retryOperation != null) {
                    op = this._retryOperation;
                }
                result = op.execute();
                lastError = null;
                shouldRetryOperation = false;
            }
            catch (Exception e) {
                lastError = e;
                if (this._retryStrategy.shouldRetry(e, this._operation.getName(), retryAttempt)) {
                    shouldRetryOperation = true;
                    ++retryAttempt;
                    continue;
                }
                shouldRetryOperation = false;
            }
        } while (shouldRetryOperation);
        if (lastError != null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)String.format("Failed to execute operation: %s, after %s retry attempts.", this._operation.getName(), retryAttempt));
            }
            throw lastError;
        }
        if (retryAttempt > 0 && _log.isWarnEnabled()) {
            _log.warn((Object)String.format("Successfully executed operation: %s, after %s retry attempts.", this._operation.getName(), retryAttempt));
        }
        return result;
    }

    @Override
    public String getName() {
        return this._operation.getName();
    }
}

