/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.i18n;

import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.datatype.XMLGregorianCalendar;

public class LocaleUtil {
    private static final String LOCALE_SEPARATOR_1 = "_";
    private static final String LOCALE_SEPARATOR_2 = "-";

    public static ResourceBundle getDefaultResourceBundle(String baseName) {
        return LocaleUtil.getResourceBundle(baseName, new Locale("", "", ""));
    }

    public static ResourceBundle getResourceBundle(String baseName, String localeCode) {
        Locale locale = LocaleUtil.localeCodeToLocale(localeCode);
        return LocaleUtil.getResourceBundle(baseName, locale);
    }

    public static ResourceBundle getResourceBundle(String baseName, Locale locale) {
        boolean countryMatch;
        ResourceBundle bundle = ResourceBundle.getBundle(baseName, locale);
        Locale bundleLocale = bundle.getLocale();
        boolean languageMatch = bundleLocale.getLanguage().equals(locale.getLanguage());
        boolean bl = countryMatch = "".equals(bundleLocale.getCountry()) || locale.getCountry().equals(bundleLocale.getCountry());
        if (!languageMatch || !countryMatch) {
            locale = new Locale("", "", "");
            bundle = ResourceBundle.getBundle(baseName, locale);
        }
        return bundle;
    }

    public static Locale localeCodeToLocale(String localeCode) {
        String foundSeparator = null;
        int separator1Index = localeCode.indexOf(LOCALE_SEPARATOR_1);
        int separator2Index = localeCode.indexOf(LOCALE_SEPARATOR_2);
        if (separator1Index != -1 && separator2Index != -1) {
            foundSeparator = separator1Index < separator2Index ? LOCALE_SEPARATOR_1 : LOCALE_SEPARATOR_2;
        } else if (separator1Index != -1) {
            foundSeparator = LOCALE_SEPARATOR_1;
        } else if (separator2Index != -1) {
            foundSeparator = LOCALE_SEPARATOR_2;
        }
        String language = null;
        String country = null;
        String variant = null;
        if (foundSeparator != null) {
            String[] languageCountryVariant = localeCode.split(foundSeparator, 3);
            if (languageCountryVariant.length == 3) {
                language = languageCountryVariant[0];
                country = languageCountryVariant[1];
                variant = languageCountryVariant[2];
            } else if (languageCountryVariant.length == 2) {
                language = languageCountryVariant[0];
                country = languageCountryVariant[1];
            } else {
                language = languageCountryVariant[0];
            }
        } else {
            language = localeCode;
        }
        if (variant != null) {
            return new Locale(language, country, variant);
        }
        if (country != null) {
            return new Locale(language, country);
        }
        return new Locale(language);
    }

    public static KeyAnyValue[] toLocalizableMessageArgs(List<Object> values) {
        ArrayList<KeyAnyValue> keyAnyValues = new ArrayList<KeyAnyValue>();
        int i = 0;
        for (Object val : values) {
            keyAnyValues.add(LocaleUtil.toLocalizableMessageArg(Integer.toString(i++), val));
        }
        return keyAnyValues.toArray(new KeyAnyValue[keyAnyValues.size()]);
    }

    private static KeyAnyValue toLocalizableMessageArg(String key, Object obj) {
        if (obj == null) {
            throw new IllegalArgumentException("Message argument cannot be null");
        }
        KeyAnyValueImpl kv = new KeyAnyValueImpl();
        kv.setKey(key);
        if (obj instanceof XMLGregorianCalendar) {
            kv.setValue((Object)((XMLGregorianCalendar)obj).toGregorianCalendar());
        } else {
            kv.setValue(obj);
        }
        return kv;
    }
}

