/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.misc;

import com.vmware.cis.license.common.cache.Cache;
import com.vmware.cis.license.common.cache.impl.LruCacheImpl;
import com.vmware.cis.license.common.misc.Util;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

public class DateUtil {
    public static final long MS_IN_SECOND = 1000L;
    public static final long MS_IN_MINUTE = 60000L;
    public static final long MS_IN_HOUR = 3600000L;
    public static final long MS_IN_DAY = 86400000L;
    public static final long MS_IN_YEAR = 31536000000L;
    public static final long MINS_IN_HOUR = 60L;
    public static final String LIC_DB_TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final SimpleDateFormat ISO_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private static final SimpleDateFormat ISO_ZULU_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final SimpleDateFormat ISO_FRACT_SEC_ZULU_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS'Z'");
    private static final SimpleDateFormat ISO_TZ_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final SimpleDateFormat ISO_FRACT_SEC_TZ_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSSZ");
    private static final Cache<String, DateFormat> _datePatternToDateFormat = new LruCacheImpl<String, DateFormat>(5);
    private static final TimeZone UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
    private static final Object _lock = new Object();

    public static List<Period> chunkPeriod(Date start, Date end, long interval) {
        Period period;
        ArrayList<Period> periods = new ArrayList<Period>();
        Date periodStart = start;
        Date periodEnd = new Date(periodStart.getTime() + interval);
        while (periodEnd.before(end)) {
            period = new Period();
            period.start = periodStart;
            period.end = periodEnd;
            periods.add(period);
            periodStart = new Date(periodEnd.getTime() + 1L);
            periodEnd = new Date(periodStart.getTime() + interval);
        }
        if (periodStart.before(end)) {
            periodEnd = end;
            period = new Period();
            period.start = periodStart;
            period.end = periodEnd;
            periods.add(period);
        }
        return periods;
    }

    public static Calendar createGMTCalendar() {
        return DateUtil.createCalendar(TimeZone.getTimeZone("GMT"));
    }

    public static Calendar createCalendar(TimeZone timeZone) {
        return new GregorianCalendar(timeZone, Locale.US);
    }

    public static Calendar createUTCCalendar() {
        return new GregorianCalendar(TimeZone.getTimeZone("UTC"), Locale.US);
    }

    public static Calendar createUTCCalendar(Date date) {
        Calendar calendar = DateUtil.createUTCCalendar();
        calendar.setTime(date);
        return calendar;
    }

    public static Date parseISODate(String dateStr) throws ParseException {
        Calendar calendar = DateUtil.parseISODateAsCalendar(dateStr);
        return calendar.getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Calendar parseISODateAsCalendar(String dateStr) throws ParseException {
        if (dateStr != null) {
            dateStr = dateStr.trim();
        }
        if (Util.isNullOrEmpty(dateStr)) {
            throw new ParseException("Given date string is empty", 0);
        }
        Date date = null;
        int zoneOffset = 0;
        Object object = _lock;
        synchronized (object) {
            if (dateStr.length() == 10) {
                date = ISO_DATE_FORMAT.parse(dateStr);
                zoneOffset = 0;
            } else if (dateStr.endsWith("Z")) {
                try {
                    date = ISO_ZULU_FORMAT.parse(dateStr);
                    zoneOffset = 0;
                }
                catch (ParseException e) {
                    date = ISO_FRACT_SEC_ZULU_FORMAT.parse(dateStr);
                    zoneOffset = 0;
                }
            } else {
                dateStr = DateUtil.fixTimeZoneFormat(dateStr);
                try {
                    date = ISO_TZ_FORMAT.parse(dateStr);
                    zoneOffset = ISO_TZ_FORMAT.getCalendar().get(15);
                }
                catch (ParseException e) {
                    date = ISO_FRACT_SEC_TZ_FORMAT.parse(dateStr);
                    zoneOffset = ISO_FRACT_SEC_TZ_FORMAT.getCalendar().get(15);
                }
            }
        }
        TimeZone timeZone = DateUtil.convertZoneOffsetToTimeZone(zoneOffset);
        Calendar calendar = Calendar.getInstance(timeZone);
        calendar.setTime(date);
        return calendar;
    }

    public static TimeZone convertZoneOffsetToTimeZone(int zoneOffset) throws ParseException {
        String sign = "+";
        if (zoneOffset < 0) {
            sign = "-";
            zoneOffset = Math.abs(zoneOffset);
        }
        long totalMinutes = (long)zoneOffset / 60000L;
        int minutes = (int)(totalMinutes % 60L);
        int hours = (int)(totalMinutes / 60L);
        if (hours >= 24) {
            throw new ParseException("Zone offset cannot be more then 23:59 hours", 0);
        }
        String gmtId = String.format("GMT%s%02d:%02d", sign, hours, minutes);
        TimeZone timeZone = TimeZone.getTimeZone(gmtId);
        return timeZone;
    }

    public static String fixTimeZoneFormat(String dateStr) throws ParseException {
        StringBuffer b = new StringBuffer(dateStr);
        int tPos = b.lastIndexOf("T");
        int tzColonPos = b.lastIndexOf(":");
        int signPlusPos = b.lastIndexOf("+");
        int signMinusPos = b.lastIndexOf("-");
        if (tPos > 0 && tPos < signPlusPos && signPlusPos < tzColonPos || tPos > 0 && tPos < signMinusPos && signMinusPos < tzColonPos) {
            try {
                dateStr = b.replace(tzColonPos, tzColonPos + 1, "").toString();
            }
            catch (StringIndexOutOfBoundsException e) {
                throw new ParseException(String.format("Cannot parse %s", dateStr), 0);
            }
        }
        return dateStr;
    }

    public static Calendar parseISODateAsGMTCalendar(String dateStr) throws ParseException {
        Date date = DateUtil.parseISODate(dateStr);
        Calendar calendar = DateUtil.createGMTCalendar();
        calendar.setTime(date);
        return calendar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date parseDateWithPattern(String dateStr, String datePattern) throws ParseException {
        if (dateStr != null) {
            dateStr = dateStr.trim();
        }
        if (Util.isNullOrEmpty(dateStr)) {
            throw new ParseException("Given date string is null or empty", 0);
        }
        if (Util.isNullOrEmpty(datePattern)) {
            throw new ParseException("Given date pattern is null or empty", 0);
        }
        Object object = _lock;
        synchronized (object) {
            DateFormat dateFormat = _datePatternToDateFormat.get(datePattern);
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(datePattern);
                dateFormat.setTimeZone(UTC_TIME_ZONE);
                _datePatternToDateFormat.put(datePattern, dateFormat);
            }
            return dateFormat.parse(dateStr);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatISODateZulu(Date date) {
        Object object = _lock;
        synchronized (object) {
            ISO_ZULU_FORMAT.setTimeZone(UTC_TIME_ZONE);
            String dateStr = ISO_ZULU_FORMAT.format(date);
            return dateStr;
        }
    }

    public static String formatISODate(Date date) {
        return DateUtil.formatISODate(date, UTC_TIME_ZONE);
    }

    public static String formatISODate(Calendar calendar) {
        return DateUtil.formatISODate(calendar.getTime(), calendar.getTimeZone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatISODate(Date date, TimeZone timeZone) {
        Object object = _lock;
        synchronized (object) {
            ISO_TZ_FORMAT.setTimeZone(timeZone);
            String dateStr = ISO_TZ_FORMAT.format(date);
            dateStr = dateStr.substring(0, dateStr.length() - 2) + ":" + dateStr.substring(dateStr.length() - 2);
            return dateStr;
        }
    }

    public static String formatISODateShort(Date date) {
        return ISO_DATE_FORMAT.format(date);
    }

    public static Date getDayStart(Date date, Calendar cal) {
        cal.setTime(date);
        cal.set(11, cal.getActualMinimum(11));
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        return new Date(cal.getTimeInMillis());
    }

    public static Date getDayEnd(Date date, Calendar cal) {
        cal.setTime(date);
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        return new Date(cal.getTimeInMillis());
    }

    public static Date getHourStart(Date date, Calendar cal) {
        cal.setTime(date);
        cal.set(12, cal.getActualMinimum(12));
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        return new Date(cal.getTimeInMillis());
    }

    public static Date getDateWithMinutePrecision(Date date, Calendar cal) {
        cal.setTime(date);
        cal.set(13, cal.getActualMinimum(13));
        cal.set(14, cal.getActualMinimum(14));
        return new Date(cal.getTimeInMillis());
    }

    public static boolean isDateInTheFuture(Date date) {
        return DateUtil.createGMTCalendar().getTime().before(date);
    }

    public static boolean isCalendarInTheFuture(Calendar cal) {
        return DateUtil.createGMTCalendar().before(cal);
    }

    static {
        ISO_DATE_FORMAT.setTimeZone(UTC_TIME_ZONE);
        ISO_ZULU_FORMAT.setTimeZone(UTC_TIME_ZONE);
        ISO_FRACT_SEC_ZULU_FORMAT.setTimeZone(UTC_TIME_ZONE);
        ISO_TZ_FORMAT.setTimeZone(UTC_TIME_ZONE);
        ISO_FRACT_SEC_TZ_FORMAT.setTimeZone(UTC_TIME_ZONE);
    }

    public static class Period {
        public Date start;
        public Date end;

        public String toString() {
            if (this.start != null && this.end != null) {
                return "Start: " + this.start.toString() + ", End: " + this.end.toString();
            }
            return "Empty period";
        }
    }
}

