/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.misc;

import com.vmware.cis.license.common.misc.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionUtil {
    public static int compareVersions(String version1, String version2) {
        int unpackV2Size;
        List<?> unpackV1 = VersionUtil.unpackVersion(version1);
        List<?> unpackV2 = VersionUtil.unpackVersion(version2);
        int unpackV1Size = unpackV1.size();
        int minSize = unpackV1Size < (unpackV2Size = unpackV2.size()) ? unpackV1Size : unpackV2Size;
        for (int i = 0; i < minSize; ++i) {
            Object objV1 = unpackV1.get(i);
            Object objV2 = unpackV2.get(i);
            if (objV1 instanceof Integer && objV2 instanceof Integer) {
                Integer intV1 = (Integer)objV1;
                Integer intV2 = (Integer)objV2;
                if (intV1 > intV2) {
                    return 1;
                }
                if (intV1 >= intV2) continue;
                return -1;
            }
            if (objV1 instanceof String && objV2 instanceof String) {
                String strV1 = (String)objV1;
                String strV2 = (String)objV2;
                int strCmp = strV1.compareTo(strV2);
                if (strCmp == 0) continue;
                return strCmp;
            }
            if (objV1 instanceof Integer) {
                return 1;
            }
            return -1;
        }
        if (unpackV1Size > unpackV2Size) {
            return 1;
        }
        if (unpackV1Size < unpackV2Size) {
            return -1;
        }
        return 0;
    }

    public static List<?> unpackVersion(String version) {
        Pattern VERSION_NUM_WITH_SUFFIX = Pattern.compile("([0-9]+)(.*)");
        String string = version = version != null ? version.trim() : null;
        if (Util.isNullOrEmpty(version)) {
            throw new IllegalArgumentException("Cannot unpack empty version.");
        }
        if (version.indexOf("..") >= 0 || version.startsWith(".") || version.endsWith(".")) {
            throw new IllegalArgumentException("Cannot unpack version that contains missing token: " + version);
        }
        StringTokenizer st = new StringTokenizer(version, ".");
        ArrayList<Object> res = new ArrayList<Object>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            Matcher matcher = VERSION_NUM_WITH_SUFFIX.matcher(token = token.trim());
            if (matcher.matches()) {
                String g1 = matcher.group(1);
                String g2 = matcher.group(2);
                res.add(Integer.parseInt(g1));
                if ((g2 = g2.trim()).length() <= 0) continue;
                res.add(g2);
                continue;
            }
            throw new IllegalArgumentException("Token: '" + token + "' in version: '" + version + "' does not start with a number.");
        }
        return res;
    }
}

