/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.license.common.serialization.impl;

import com.vmware.cis.license.common.serialization.DeserializeException;
import com.vmware.cis.license.common.serialization.Deserializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseDeserializer<T>
implements Deserializer<T> {
    @Override
    public T deserializeData(byte[] data) throws DeserializeException {
        T t;
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        try {
            t = this.deserializeData(bais);
        }
        catch (IOException e) {
            throw new DeserializeException("Failed to deserialize data", e);
        }
        finally {
            try {
                bais.close();
            }
            catch (Exception e) {}
        }
        return t;
    }

    public abstract T deserializeData(InputStream var1) throws DeserializeException, IOException;
}

