/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.google.common.collect.Lists;
import com.vmware.vim.binding.vim.vm.FileLayoutEx;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.FormatUtil;
import com.vmware.vsphere.client.commonservice.SnapshotDiskUsage;
import com.vmware.vsphere.client.vm.model.DiskUsage;
import java.util.ArrayList;
import java.util.List;

public class DiskUsagePropertyProvider
implements PropertyProviderBean {
    private QueryExecutor queryExecutor;

    public DiskUsagePropertyProvider(QueryExecutor queryExecutor) {
        this.queryExecutor = queryExecutor;
    }

    @type(value="VirtualMachine")
    public DiskUsage getDiskUsage(ManagedObjectReference vmRef) throws Exception {
        FileLayoutEx layoutEx = (FileLayoutEx)this.queryExecutor.getProperty((Object)vmRef, "layoutEx");
        return new DiskUsage(FormatUtil.getStorageFormatted((Long)this.getCurrentDiskUsage(layoutEx), (long)1L, (long)-1L), FormatUtil.getStorageFormatted((Long)this.getTotalDiskUsage(layoutEx), (long)1L, (long)-1L), this.getSnapshotDiskUsage(layoutEx));
    }

    private List<SnapshotDiskUsage> getSnapshotDiskUsage(FileLayoutEx layoutEx) {
        FileLayoutEx.SnapshotLayout[] snapshotLayouts = layoutEx.getSnapshot();
        if (snapshotLayouts == null) {
            return Lists.newArrayList();
        }
        ArrayList snapshotDiskUsage = Lists.newArrayList();
        for (FileLayoutEx.SnapshotLayout snapshot : snapshotLayouts) {
            long currentSnapshotDiskUsage = this.getFileSize(snapshot.getDataKey(), layoutEx) + this.getSnapshotDiskSize(layoutEx, snapshot);
            String formattedDiskUsage = FormatUtil.getStorageFormatted((Long)currentSnapshotDiskUsage, (long)1L, (long)-1L);
            snapshotDiskUsage.add(new SnapshotDiskUsage(snapshot.getKey().getValue(), formattedDiskUsage));
        }
        return snapshotDiskUsage;
    }

    private long getSnapshotDiskSize(FileLayoutEx layoutEx, FileLayoutEx.SnapshotLayout snapshot) {
        long snapshotDiskSize = 0L;
        for (FileLayoutEx.DiskLayout disk : snapshot.getDisk()) {
            FileLayoutEx.DiskUnit lastDiskChain = disk.getChain()[disk.getChain().length - 1];
            for (int fileKey : lastDiskChain.getFileKey()) {
                snapshotDiskSize += this.getFileSize(fileKey, layoutEx);
            }
        }
        return snapshotDiskSize;
    }

    private long getTotalDiskUsage(FileLayoutEx layoutEx) {
        long totalSize = 0L;
        for (FileLayoutEx.FileInfo fileInfo : layoutEx.getFile()) {
            totalSize += fileInfo.getSize();
        }
        return totalSize;
    }

    private long getCurrentDiskUsage(FileLayoutEx layoutEx) {
        long totalSize = 0L;
        for (FileLayoutEx.FileInfo fileInfo : layoutEx.getFile()) {
            if (!fileInfo.getType().equals("swap")) continue;
            totalSize += fileInfo.getSize();
        }
        return totalSize += this.getDiskSize(layoutEx);
    }

    private long getDiskSize(FileLayoutEx layoutEx) {
        long totalSize = 0L;
        for (FileLayoutEx.DiskLayout disk : layoutEx.getDisk()) {
            FileLayoutEx.DiskUnit lastDiskChain = disk.getChain()[disk.getChain().length - 1];
            for (int fileKey : lastDiskChain.getFileKey()) {
                totalSize += this.getFileSize(fileKey, layoutEx);
            }
        }
        return totalSize;
    }

    private long getFileSize(int fileKey, FileLayoutEx layoutEx) {
        for (FileLayoutEx.FileInfo file : layoutEx.getFile()) {
            if (file.key != fileKey) continue;
            return file.getSize();
        }
        return 0L;
    }
}

