/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.ConfigOptionDescriptor;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class VirtualHardwareUpgradePropertyProvider {
    private QueryService _queryService;
    static final String CONFIG_VERSION = "config.version";
    static final String OPTION_DESCRIPTORS = "optionDescriptors";

    public VirtualHardwareUpgradePropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="VirtualMachine/isScheduleVmVirtualHardwareUpgradeAvailable")
    public Collection<Boolean> getIsScheduleVmVirtualHardwareUpgradeAvailable(Collection<ManagedObjectReference> objects) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(objects.size());
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", CONFIG_VERSION, OPTION_DESCRIPTORS}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, objects).fetch();
        HashMap<ManagedObjectReference, Boolean> propValueMap = new HashMap<ManagedObjectReference, Boolean>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            String vmHwVersion = (String)resourceItem.get(CONFIG_VERSION);
            Object[] optionDescriptors = (ConfigOptionDescriptor[])resourceItem.get(OPTION_DESCRIPTORS);
            boolean isScheduleUpgradeAvailable = false;
            for (ConfigOptionDescriptor optionDescriptor : (ConfigOptionDescriptor[])ArrayUtil.toSafe((Object[])optionDescriptors, ConfigOptionDescriptor.class)) {
                if (!optionDescriptor.getUpgradeSupported().booleanValue() || vmHwVersion.compareTo(optionDescriptor.getKey()) >= 0) continue;
                isScheduleUpgradeAvailable = true;
                break;
            }
            propValueMap.put((ManagedObjectReference)resourceItem.getKey(), isScheduleUpgradeAvailable);
        }
        for (ManagedObjectReference object : objects) {
            result.add((Boolean)propValueMap.get(object));
        }
        return result;
    }
}

