/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.vim.binding.vim.CustomizationSpecManager;
import com.vmware.vim.binding.vim.fault.MissingLinuxCustResources;
import com.vmware.vim.binding.vim.fault.MissingWindowsCustResources;
import com.vmware.vim.binding.vim.fault.UncustomizableGuest;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.vm.data.CustomizationSpecData;

public class VmCustomizationSpecsPropertyProvider
implements PropertyProviderBean {
    @type(value="VirtualMachine")
    public CustomizationSpecData getCustomizationSpecData(ManagedObjectReference vmRef, String guestId) throws Exception {
        assert (vmRef != null);
        VcService service = VimSessionUtil.getService((String)vmRef.getServerGuid());
        CustomizationSpecManager manager = (CustomizationSpecManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)service.getServiceInstanceContent().customizationSpecManager);
        CustomizationSpecData result = new CustomizationSpecData();
        result.compatibility = CustomizationSpecData.CustomizationCompatibility.CUSTOMIZATION_RESOURCES_VALID;
        try {
            manager.checkResources(guestId);
            result.customizationSpecs = manager.getInfo();
        }
        catch (MissingWindowsCustResources e) {
            result.compatibility = CustomizationSpecData.CustomizationCompatibility.MISSING_WINDOWS_CUSTOMIZATION;
        }
        catch (MissingLinuxCustResources e) {
            result.compatibility = CustomizationSpecData.CustomizationCompatibility.MISSING_LINUX_CUSTOMIZATION;
        }
        catch (UncustomizableGuest e) {
            result.compatibility = CustomizationSpecData.CustomizationCompatibility.UNCUSTOMIZABLE_GUEST;
        }
        return result;
    }
}

