/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class VmPropertyProvider {
    private static final String TOOLS_INSTALLER_MOUNTED_PROP = "runtime.toolsInstallerMounted";
    private static final String FT_ROLE_PROP = "ftRole";
    private QueryService _queryService;

    public VmPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="VirtualMachine/isInstallUpgradeVmToolsAvailable")
    public Collection<Boolean> getIsInstallUpgradeVmToolsAvailable(Collection<ManagedObjectReference> vmRefs) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(vmRefs.size());
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", TOOLS_INSTALLER_MOUNTED_PROP, FT_ROLE_PROP}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vmRefs).fetch();
        HashMap<ManagedObjectReference, Boolean> propValueMap = new HashMap<ManagedObjectReference, Boolean>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Boolean toolsInstallerMounted = (Boolean)resourceItem.get(TOOLS_INSTALLER_MOUNTED_PROP);
            Integer ftRole = (Integer)resourceItem.get(FT_ROLE_PROP);
            boolean isInstallUpgradeAvailable = toolsInstallerMounted == false && (ftRole == null || ftRole <= 1);
            propValueMap.put((ManagedObjectReference)resourceItem.getKey(), isInstallUpgradeAvailable);
        }
        for (ManagedObjectReference vmRef : vmRefs) {
            result.add((Boolean)propValueMap.get(vmRef));
        }
        return result;
    }
}

