/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm;

import com.vmware.vim.binding.vim.vm.ScheduledHardwareUpgradeInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.commonservice.util.Util;

public class VmToolsPropertyProvider
implements PropertyProviderBean {
    static final String TOOLS_RUNNING_STATUS = "toolsRunningStatus";
    static final String TOOLS_VERSION_STATUS = "toolsVersionStatus";
    static final String GUEST_TOOLS_NOT_RUNNING = "guestToolsNotRunning";
    static final String GUEST_TOOLS_RUNNING = "guestToolsRunning";
    static final String GUEST_TOOLS_NEED_UPGRADE = "guestToolsNeedUpgrade";
    static final String GUEST_TOOLS_SUPPORTED_OLD = "guestToolsSupportedOld";
    private static final String CONFIG_SCHEDULE_INFO_PROPERTY = "config.scheduledHardwareUpgradeInfo";
    private QueryExecutor _queryExecutor;

    public void setQueryExecutor(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    @type(value="VirtualMachine")
    public boolean getToolsInstalled(ManagedObjectReference vmRef) throws Exception {
        PropertyValue[] pvs = this._queryExecutor.getProperties((Object)vmRef, new String[]{TOOLS_RUNNING_STATUS});
        Object property = Util.getProperty((PropertyValue[])pvs, (String)TOOLS_RUNNING_STATUS);
        if (property == null) {
            return false;
        }
        String prop = (String)property;
        return !GUEST_TOOLS_NOT_RUNNING.equalsIgnoreCase(prop);
    }

    @type(value="VirtualMachine")
    public boolean getUpgradeAvailable(ManagedObjectReference vmRef) throws Exception {
        PropertyValue[] pvs = this._queryExecutor.getProperties((Object)vmRef, new String[]{TOOLS_RUNNING_STATUS, TOOLS_VERSION_STATUS});
        Object runningStatusProp = Util.getProperty((PropertyValue[])pvs, (String)TOOLS_RUNNING_STATUS);
        Object needsUpgradeProp = Util.getProperty((PropertyValue[])pvs, (String)TOOLS_VERSION_STATUS);
        if (runningStatusProp == null || needsUpgradeProp == null) {
            return false;
        }
        String runningStatus = (String)runningStatusProp;
        String needsUpgradeStatus = (String)needsUpgradeProp;
        if (GUEST_TOOLS_NOT_RUNNING.equalsIgnoreCase(runningStatus)) {
            return false;
        }
        return GUEST_TOOLS_NEED_UPGRADE.equalsIgnoreCase(needsUpgradeStatus) || GUEST_TOOLS_SUPPORTED_OLD.equalsIgnoreCase(needsUpgradeStatus);
    }

    @type(value="VirtualMachine")
    public boolean getIsCancelHardwareUpgradeAvailable(ManagedObjectReference vmRef) throws Exception {
        ScheduledHardwareUpgradeInfo hwUpgradeInfo = (ScheduledHardwareUpgradeInfo)this._queryExecutor.getProperty((Object)vmRef, CONFIG_SCHEDULE_INFO_PROPERTY);
        boolean isCancelAvailable = hwUpgradeInfo != null && !StringUtil.isNullOrEmpty((String)hwUpgradeInfo.getVersionKey());
        return isCancelAvailable;
    }
}

