/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.EntitySpecPair;
import com.vmware.vise.core.model.OperationEffect;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.mutation.MutationService;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vsphere.client.h5.vm.MultipleVmQuestionAnswerSpec;
import com.vmware.vsphere.client.vm.api.VmQuestionAnswerSpec;
import java.util.ArrayList;
import java.util.Arrays;

public class VmMutationProvider
implements MutationProvider {
    private static final String VM_QUESTION_ID_PROP_NAME = "runtime/question/id";
    private static final String VM_QUESTION_FIRST_MESSAGE_ID_PROP_NAME = "vmQuestionId";
    public final MutationService _mutationService;
    public final QueryServiceFactory _queryServiceFactory;

    public VmMutationProvider(MutationService mutationService, QueryServiceFactory queryServiceFactory) {
        this._mutationService = mutationService;
        this._queryServiceFactory = queryServiceFactory;
    }

    public OperationResult apply(ManagedObjectReference vmRef, MultipleVmQuestionAnswerSpec multipleVmsAnswerSpec) {
        EntitySpecPair[] specPairs;
        VmQuestionAnswerSpec sourceVmAnswerSpec = new VmQuestionAnswerSpec();
        sourceVmAnswerSpec.questionId = multipleVmsAnswerSpec.questionId;
        sourceVmAnswerSpec.answerChoice = multipleVmsAnswerSpec.answerChoice;
        ArrayList<ManagedObjectReference> vmsToAnswer = new ArrayList<ManagedObjectReference>();
        vmsToAnswer.add(vmRef);
        if (ArrayUtil.isNullOrEmpty((Object[])multipleVmsAnswerSpec.otherVmRefs)) {
            EntitySpecPair specPair = this.getSpecPair(vmRef, sourceVmAnswerSpec);
            specPairs = new EntitySpecPair[]{specPair};
        } else {
            QueryService queryService = this._queryServiceFactory.getQueryService();
            ResultSet vmQuestionIds = queryService.select(new String[]{"@modelKey", VM_QUESTION_ID_PROP_NAME}).from(new String[]{VirtualMachine.class.getSimpleName()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.IN, Arrays.asList(multipleVmsAnswerSpec.otherVmRefs)), new PropertyPredicate(VM_QUESTION_FIRST_MESSAGE_ID_PROP_NAME, PropertyPredicate.ComparisonOperator.EQUAL, (Object)multipleVmsAnswerSpec.firstMessageId)}).fetch();
            Integer otherVmsCount = vmQuestionIds.getItems().size();
            specPairs = new EntitySpecPair[otherVmsCount + 1];
            specPairs[0] = this.getSpecPair(vmRef, sourceVmAnswerSpec);
            Integer index = 1;
            for (ResourceItem vmQuestionIdItem : vmQuestionIds.getItems()) {
                ManagedObjectReference otherVmRef = (ManagedObjectReference)vmQuestionIdItem.getKey();
                vmsToAnswer.add(otherVmRef);
                String otherVmQuestionId = vmQuestionIdItem.getPropertyValues().get(1).toString();
                VmQuestionAnswerSpec otherVmAnswerSpec = new VmQuestionAnswerSpec();
                otherVmAnswerSpec.questionId = otherVmQuestionId;
                otherVmAnswerSpec.answerChoice = sourceVmAnswerSpec.answerChoice;
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                specPairs[n.intValue()] = this.getSpecPair(otherVmRef, otherVmAnswerSpec);
            }
        }
        this._mutationService.applyMulti(specPairs);
        OperationResult result = new OperationResult();
        result.entity = vmRef;
        result.effect = new OperationEffect();
        result.effect.affectedEntites = vmsToAnswer.toArray(new ManagedObjectReference[0]);
        return result;
    }

    private EntitySpecPair getSpecPair(ManagedObjectReference ref, VmQuestionAnswerSpec spec) {
        EntitySpecPair pairSpec = new EntitySpecPair();
        pairSpec.entity = ref;
        pairSpec.spec = spec;
        return pairSpec;
    }
}

