/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.email.impl;

import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.clientError.ErrorSpec;
import com.vmware.vsphere.client.email.EmailSpec;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import javax.activation.CommandMap;
import javax.activation.MailcapCommandMap;
import javax.mail.MessagingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EmailMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(EmailMutationProvider.class);
    private static final String POST_URL = "http://mvdb-quad.eng.vmware.com/%s/ReportInstance.aspx";
    private static final String EMAIL_GROUP = "ngc-unhandled@vmware.com";
    private ErrorReporter _errorReporter = new ErrorReporter();
    private EmailReporter _emailReporter = new EmailReporter();
    private static final String ERROR_APP = "ErrorUi";
    private static final boolean DISABLE_EMAIL = true;

    public OperationResult add(EmailSpec emailSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            this._emailReporter.post(emailSpec);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            operationResult.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return operationResult;
    }

    public OperationResult add(ErrorSpec errorSpec) {
        OperationResult operationResult = new OperationResult();
        try {
            this._errorReporter.post(errorSpec);
        }
        catch (Exception exception) {
            EmailSpec emailSpec = this.createEmailSpec(errorSpec);
            try {
                this._emailReporter.post(emailSpec);
            }
            catch (Exception exception2) {
                _logger.error((Object)exception2);
                operationResult.error = MixedUtil.getMethodFault((Throwable)exception2);
            }
        }
        return operationResult;
    }

    private EmailSpec createEmailSpec(ErrorSpec errorSpec) {
        EmailSpec emailSpec = new EmailSpec();
        emailSpec.to = new String[]{EMAIL_GROUP};
        emailSpec.from = EMAIL_GROUP;
        emailSpec.subject = String.format("Unhandled Error: %s\n", errorSpec.message);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("Version:%s\n", errorSpec.version));
        stringBuilder.append(String.format("Build:%d\n\n", Integer.toString(errorSpec.build)));
        stringBuilder.append(String.format("EventHistory:%s\n", errorSpec.eventHistory));
        stringBuilder.append(String.format("URL:%s\n", errorSpec.url));
        stringBuilder.append(String.format("%s\n", errorSpec.message));
        stringBuilder.append(String.format("%s\n", errorSpec.stackTrace));
        emailSpec.body = stringBuilder.toString();
        return emailSpec;
    }

    private class EmailReporter {
        private EmailReporter() {
        }

        private void post(EmailSpec emailSpec) throws MessagingException {
        }

        private void addMIMEtypes() {
            MailcapCommandMap mailcapCommandMap = (MailcapCommandMap)CommandMap.getDefaultCommandMap();
            mailcapCommandMap.addMailcap("text/html;; x-java-content-handler=com.sun.mail.handlers.text_html");
            mailcapCommandMap.addMailcap("text/xml;; x-java-content-handler=com.sun.mail.handlers.text_xml");
            mailcapCommandMap.addMailcap("text/plain;; x-java-content-handler=com.sun.mail.handlers.text_plain");
            mailcapCommandMap.addMailcap("multipart/*;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mailcapCommandMap.addMailcap("multipart/mixed;; x-java-content-handler=com.sun.mail.handlers.multipart_mixed");
            mailcapCommandMap.addMailcap("message/rfc822;; x-java-content-handler=com.sun.mail.handlers.message_rfc822");
            CommandMap.setDefaultCommandMap((CommandMap)mailcapCommandMap);
        }
    }

    private class ErrorReporter {
        private ErrorReporter() {
        }

        private boolean post(ErrorSpec errorSpec) throws MalformedURLException, UnknownHostException {
            return false;
        }
    }
}

