/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error;

import com.vmware.vise.util.StringUtil;
import com.vmware.vsphere.client.error.FaultData;
import com.vmware.vsphere.client.error.SourceData;
import com.vmware.vsphere.client.error.StackMessage;
import com.vmware.vsphere.client.error.xml.XmlArray;
import com.vmware.vsphere.client.error.xml.XmlElement;
import com.vmware.vsphere.client.error.xml.XmlRoot;
import com.vmware.vsphere.client.error.xml.XmlSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@XmlRoot(value="EventData")
public class AssistanceData {
    public static final String CR = "\n";
    public static final String SOURCE_EVENT = "event";
    public static final String SOURCE_TASK = "task";
    public static final String SOURCE_FAULT = "fault";
    public static final String SOURCE_UNKNOWN = null;
    private String _sourceType = SOURCE_UNKNOWN;
    private List<SourceData> _sourceData = new ArrayList<SourceData>();
    private FaultData _fault;

    @XmlElement(value="Source")
    public String getSourceType() {
        return this._sourceType;
    }

    public void setSourceType(String string) {
        this._sourceType = string;
    }

    @XmlArray(value="SourceData")
    public List<SourceData> getSourceData() {
        return Collections.unmodifiableList(this._sourceData);
    }

    @XmlArray(value="MessageInfo")
    public List<StackMessage> getMessageInfo() {
        return this._fault == null ? null : this._fault.getMessageInfo();
    }

    @XmlArray(value="Cause")
    public List<FaultData> getCause() {
        return this._fault == null ? null : this._fault.getCause();
    }

    public void addSourceData(String string, Object object) {
        if (object == null) {
            return;
        }
        if (object instanceof String && StringUtil.isNullOrEmpty((String)((String)object))) {
            return;
        }
        this._sourceData.add(new SourceData(string, object));
    }

    public void setFaultData(FaultData faultData) {
        this._fault = faultData;
    }

    public String toXml() {
        return XmlSerializer.toXML(this);
    }

    public String toLogString() {
        StringBuilder stringBuilder = new StringBuilder();
        this._fault.toLogDataString("", stringBuilder);
        stringBuilder.append(CR);
        stringBuilder.append("Source:");
        stringBuilder.append(this._sourceType);
        stringBuilder.append(CR);
        for (SourceData sourceData : this._sourceData) {
            sourceData.toLogDataString(stringBuilder);
        }
        return stringBuilder.toString();
    }
}

