/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.error;

import com.vmware.vsphere.client.error.ErrorReportUtil;
import com.vmware.vsphere.client.error.xml.XmlElement;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

@XmlElement(value="Data")
public class SourceData {
    private String _name;
    private List<String> _value = new ArrayList<String>();

    public SourceData(String string, Object object) {
        this._name = string;
        if (object.getClass().isArray()) {
            int n = Array.getLength(object);
            for (int i = 0; i < n; ++i) {
                Object object2 = Array.get(object, i);
                this._value.add(object2.toString());
            }
        } else if (object instanceof List) {
            List list = (List)object;
            for (Object e : list) {
                this._value.add(e.toString());
            }
        } else {
            this._value.add(object.toString());
        }
    }

    @XmlElement(value="Name")
    public String getName() {
        return this._name;
    }

    @XmlElement(value="Value")
    public List<String> getValue() {
        return this._value;
    }

    public void toLogDataString(StringBuilder stringBuilder) {
        stringBuilder.append(this.getName());
        stringBuilder.append(": ");
        if (this.getValue().size() == 0) {
            stringBuilder.append("Null");
        } else {
            int n = 0;
            for (String string : this._value) {
                if (n > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(ErrorReportUtil.formatForDisplay(string));
                ++n;
            }
        }
        stringBuilder.append("\n");
    }
}

