/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.mixed.impl;

import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.cluster.ConfigInfoEx;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.mixed.CustomParentData;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomParentPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(CustomParentPropertyProvider.class);
    private ManagedEntityParentLocator parentLocator;

    public CustomParentPropertyProvider(ManagedEntityParentLocator managedEntityParentLocator) {
        this.parentLocator = managedEntityParentLocator;
    }

    @type(value="Folder, ResourcePool")
    public CustomParentData getCustomParentData(ManagedObjectReference managedObjectReference) {
        ManagedObjectReference managedObjectReference2;
        CustomParentData customParentData = null;
        Map<ManagedObjectReference, OperationResult> map = this.parentLocator.locateCustomParents(managedObjectReference);
        OperationResult operationResult = map.get(managedObjectReference);
        if (operationResult != null && this.parentLocator.customParentRelated(managedObjectReference, managedObjectReference2 = (ManagedObjectReference)operationResult.entity)) {
            if (ComputeResource.class.equals((Object)ManagedObjectUtil.getType((ManagedObjectReference)managedObjectReference2))) {
                managedObjectReference2 = CustomParentPropertyProvider.getHostFromComputeResource(managedObjectReference2);
            }
            customParentData = new CustomParentData();
            customParentData.type = managedObjectReference2.getType();
            customParentData.name = (String)operationResult.result;
            customParentData.entity = managedObjectReference2;
        }
        return customParentData;
    }

    private static ManagedObjectReference getHostFromComputeResource(ManagedObjectReference managedObjectReference) {
        try {
            ComputeResource computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            if (!(computeResource.getConfigurationEx() instanceof ConfigInfoEx) && !ArrayUtil.isNullOrEmpty((Object[])computeResource.getHost())) {
                return computeResource.getHost()[0];
            }
            _logger.error((Object)"Did not expect compute resource to be a cluster");
        }
        catch (Exception exception) {
            _logger.error((Object)("Failed to retrieve compute resource from MOR " + managedObjectReference), (Throwable)exception);
        }
        return managedObjectReference;
    }
}

