/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.mixed.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.Datacenter;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.VirtualApp;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DeletePrivilegePropertyProviderAdapter
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(DeletePrivilegePropertyProviderAdapter.class);
    private static final String HAS_ALL_DELETE_PRIVILEGES_PROP = "hasAllDeletePrivileges";
    private static final String PARENT_RELATION = "parent";
    private static final String PARENT_VAPP_RELATION = "parentVApp";
    private static final Map<String, String[]> DELETE_PRIVILEGES_BY_TYPE;
    private final DataService _dataService;
    private final LegacyAuthorizationService _authService;

    public DeletePrivilegePropertyProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, DataService dataService, LegacyAuthorizationService legacyAuthorizationService) {
        dataServiceExtensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
        this._dataService = dataService;
        this._authService = legacyAuthorizationService;
    }

    private TypeInfo[] getProvidedTypeInfos() {
        ArrayList<TypeInfo> arrayList = new ArrayList<TypeInfo>();
        for (String string : DELETE_PRIVILEGES_BY_TYPE.keySet()) {
            TypeInfo typeInfo = new TypeInfo();
            typeInfo.type = string;
            typeInfo.properties = new String[]{HAS_ALL_DELETE_PRIVILEGES_PROP};
            arrayList.add(typeInfo);
        }
        return (TypeInfo[])ArrayUtil.toArray(arrayList, TypeInfo.class);
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequestSpec) {
        long l = System.currentTimeMillis();
        ResultSet resultSet = new ResultSet();
        try {
            ValidationUtil.paramsNotNull((Object[])new Object[]{propertyRequestSpec});
            Object[] objectArray = propertyRequestSpec.objects;
            if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
                throw new IllegalArgumentException("Property request should contain at least one object!");
            }
            resultSet.items = this.checkDeletePrivileges(objectArray);
        }
        catch (Exception exception) {
            resultSet.error = exception;
        }
        long l2 = System.currentTimeMillis();
        _logger.debug((Object)("Result for " + propertyRequestSpec.objects.length + " objects obtained for: " + (l2 - l) + " ms."));
        return resultSet;
    }

    private final ResultItem[] checkDeletePrivileges(Object[] objectArray) throws IllegalArgumentException, Exception {
        PropertyValue[] propertyValueArray = QueryUtil.getProperties((DataService)this._dataService, (Object[])objectArray, (String[])new String[]{PARENT_RELATION, PARENT_VAPP_RELATION});
        Set<ObjectParentPair> set = DeletePrivilegePropertyProviderAdapter.getObjectParentPairs(propertyValueArray);
        Map<ManagedObjectReference, Boolean> map = this.checkPrivileges(set);
        ResultItem[] resultItemArray = (ResultItem[])ArrayUtil.toArray(DeletePrivilegePropertyProviderAdapter.resultsMapToResultItemList(map), ResultItem.class);
        return resultItemArray;
    }

    private static final Set<ObjectParentPair> getObjectParentPairs(PropertyValue[] propertyValueArray) throws IllegalArgumentException {
        HashSet<ObjectParentPair> hashSet = new HashSet<ObjectParentPair>();
        for (PropertyValue propertyValue : propertyValueArray) {
            if (!(propertyValue.value instanceof ManagedObjectReference)) {
                throw new IllegalArgumentException("Parent property should refer to a managed object!");
            }
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)propertyValue.resourceObject;
            ManagedObjectReference managedObjectReference2 = (ManagedObjectReference)propertyValue.value;
            ObjectParentPair objectParentPair = new ObjectParentPair(managedObjectReference, managedObjectReference2);
            hashSet.add(objectParentPair);
        }
        return hashSet;
    }

    private final Map<ManagedObjectReference, Boolean> checkPrivileges(Set<ObjectParentPair> set) throws Exception {
        HashMap<ManagedObjectReference, Boolean> hashMap = new HashMap<ManagedObjectReference, Boolean>();
        for (ObjectParentPair objectParentPair : set) {
            ManagedObjectReference managedObjectReference = objectParentPair.object();
            ManagedObjectReference managedObjectReference2 = objectParentPair.parent();
            boolean bl = this._authService.checkPrivileges(new ManagedObjectReference[]{managedObjectReference, managedObjectReference2}, DELETE_PRIVILEGES_BY_TYPE.get(managedObjectReference.getType()));
            hashMap.put(managedObjectReference, bl);
        }
        return hashMap;
    }

    private static final List<ResultItem> resultsMapToResultItemList(Map<ManagedObjectReference, Boolean> map) {
        ArrayList<ResultItem> arrayList = new ArrayList<ResultItem>();
        for (Map.Entry<ManagedObjectReference, Boolean> entry : map.entrySet()) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = entry.getKey();
            PropertyValue propertyValue = new PropertyValue();
            propertyValue.resourceObject = entry.getKey();
            propertyValue.value = entry.getValue();
            propertyValue.propertyName = HAS_ALL_DELETE_PRIVILEGES_PROP;
            resultItem.properties = new PropertyValue[]{propertyValue};
            arrayList.add(resultItem);
        }
        return arrayList;
    }

    static {
        HashMap<String, String[]> hashMap = new HashMap<String, String[]>();
        hashMap.put(VmwareDistributedVirtualSwitch.class.getSimpleName(), new String[]{"DVSwitch.Delete"});
        hashMap.put(DistributedVirtualSwitch.class.getSimpleName(), new String[]{"DVSwitch.Delete"});
        hashMap.put(VirtualMachine.class.getSimpleName(), new String[]{"VirtualMachine.Inventory.Delete"});
        hashMap.put(Datacenter.class.getSimpleName(), new String[]{"Datacenter.Delete"});
        hashMap.put(ResourcePool.class.getSimpleName(), new String[]{"Resource.DeletePool"});
        hashMap.put(ClusterComputeResource.class.getSimpleName(), new String[]{"Host.Inventory.DeleteCluster"});
        hashMap.put(ComputeResource.class.getSimpleName(), new String[]{"Host.Inventory.RemoveHostFromCluster"});
        hashMap.put(HostSystem.class.getSimpleName(), new String[]{"Host.Inventory.RemoveHostFromCluster"});
        hashMap.put(Folder.class.getSimpleName(), new String[]{"Folder.Delete"});
        hashMap.put(VirtualApp.class.getSimpleName(), new String[]{"VApp.Delete"});
        hashMap.put(DistributedVirtualPortgroup.class.getSimpleName(), new String[]{"DVPortgroup.Delete"});
        hashMap.put(StoragePod.class.getSimpleName(), new String[]{"Folder.Delete"});
        DELETE_PRIVILEGES_BY_TYPE = Collections.unmodifiableMap(new HashMap(hashMap));
    }

    private static final class ObjectParentPair {
        private final ManagedObjectReference _objectToBeDeleted;
        private final ManagedObjectReference _parent;

        public ObjectParentPair(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) {
            this._objectToBeDeleted = managedObjectReference;
            this._parent = managedObjectReference2;
        }

        public final ManagedObjectReference object() {
            return this._objectToBeDeleted;
        }

        public final ManagedObjectReference parent() {
            return this._parent;
        }
    }
}

