/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.mixed.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.ComputeResource;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ManagedEntity;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.host.DatastoreBrowser;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vim.vm.NetworkInfo;
import com.vmware.vim.binding.vim.vm.OpaqueNetworkInfo;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.common.NameValuePair;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.common.util.NetworkUtil;
import com.vmware.vsphere.client.mixed.MixedServiceUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EnvironmentBrowserPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(EnvironmentBrowserPropertyProvider.class);
    private final DataService _dataService;
    private final LegacyAuthorizationService _authService;
    public static final String PRIVILEGE_DATASTORE_BROWSE = "Datastore.Browse";

    public EnvironmentBrowserPropertyProvider(DataService dataService, LegacyAuthorizationService legacyAuthorizationService) {
        this._dataService = dataService;
        this._authService = legacyAuthorizationService;
    }

    @type(value="VirtualMachine, HostSystem, ComputeResource, ClusterComputeResource")
    public ManagedObjectReference[] getSearchableDatastore(ManagedObjectReference managedObjectReference) throws Exception {
        try {
            ComputeResource computeResource;
            ManagedObjectReference managedObjectReference2;
            ManagedEntity managedEntity = (ManagedEntity)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
            ManagedObjectReference managedObjectReference3 = null;
            if (managedEntity instanceof VirtualMachine) {
                managedObjectReference3 = ((VirtualMachine)managedEntity).getEnvironmentBrowser();
            } else if (managedEntity instanceof HostSystem) {
                managedObjectReference2 = ((HostSystem)managedEntity).getParent();
                computeResource = (ComputeResource)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference2);
                managedObjectReference3 = computeResource.getEnvironmentBrowser();
            } else if (managedEntity instanceof ComputeResource) {
                managedObjectReference3 = ((ComputeResource)managedEntity).getEnvironmentBrowser();
            } else if (managedEntity instanceof ClusterComputeResource) {
                managedObjectReference3 = ((ClusterComputeResource)managedEntity).getEnvironmentBrowser();
            } else {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(String.format(MixedServiceUtil.getLocalizedString("getSearchableDatastore.invalidArgument"), managedObjectReference.getType()));
                throw illegalArgumentException;
            }
            managedObjectReference2 = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference3);
            computeResource = managedObjectReference2.getDatastoreBrowser();
            DatastoreBrowser datastoreBrowser = (DatastoreBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)computeResource);
            ManagedObjectReference[] managedObjectReferenceArray = datastoreBrowser.getDatastore();
            ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
            if (managedObjectReferenceArray != null) {
                for (ManagedObjectReference managedObjectReference4 : managedObjectReferenceArray) {
                    if (!this.hasDsBrowsePrivilege(managedObjectReference4)) continue;
                    arrayList.add(managedObjectReference4);
                }
            }
            return arrayList.toArray(new ManagedObjectReference[arrayList.size()]);
        }
        catch (Exception exception) {
            _logger.error((Object)"exception in getSearchableDatastore", (Throwable)exception);
            throw exception;
        }
    }

    /*
     * WARNING - void declaration
     */
    @type(value="EnvironmentBrowser")
    public NameValuePair[] getAssignableNetworks(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2) throws Exception {
        OpaqueNetworkInfo[] opaqueNetworkInfoArray;
        ManagedObjectReference managedObjectReference3;
        NetworkInfo[] networkInfoArray;
        EnvironmentBrowser environmentBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managedObjectReference);
        ConfigTarget configTarget = environmentBrowser.queryConfigTarget(managedObjectReference2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        NetworkInfo[] networkInfoArray2 = configTarget.network;
        if (networkInfoArray2 != null) {
            networkInfoArray = networkInfoArray2;
            int n = networkInfoArray.length;
            for (int i = 0; i < n; ++i) {
                NetworkInfo networkInfo = networkInfoArray[i];
                ManagedObjectReference managedObjectReference5 = networkInfo.network.network;
                if (!this.hasAssignPrivilege(managedObjectReference5)) continue;
                NameValuePair nameValuePair = new NameValuePair(networkInfo.name, (Object)managedObjectReference5);
                arrayList.add(nameValuePair);
            }
        }
        if ((networkInfoArray = configTarget.distributedVirtualPortgroup) != null) {
            for (NetworkInfo networkInfo : networkInfoArray) {
                ManagedObjectReference managedObjectReference4 = networkInfo.portgroup;
                if (NetworkUtil.isUplinkPortgroup((ManagedObjectReference)managedObjectReference4, (DataService)this._dataService) || !this.hasAssignPrivilege(managedObjectReference4)) continue;
                managedObjectReference3 = new NameValuePair(networkInfo.portgroupName, (Object)managedObjectReference4);
                arrayList.add(managedObjectReference3);
            }
        }
        if ((opaqueNetworkInfoArray = configTarget.opaqueNetwork) != null) {
            void var11_21;
            OpaqueNetworkInfo[] opaqueNetworkInfoArray2 = opaqueNetworkInfoArray;
            int n = opaqueNetworkInfoArray2.length;
            boolean bl = false;
            while (var11_21 < n) {
                OpaqueNetworkInfo opaqueNetworkInfo = opaqueNetworkInfoArray2[var11_21];
                managedObjectReference3 = opaqueNetworkInfo.network.network;
                if (this.hasAssignPrivilege(managedObjectReference3)) {
                    NameValuePair nameValuePair = new NameValuePair(opaqueNetworkInfo.name, (Object)managedObjectReference3);
                    arrayList.add(nameValuePair);
                }
                ++var11_21;
            }
        }
        NameValuePair[] nameValuePairArray = new NameValuePair[arrayList.size()];
        return arrayList.toArray(nameValuePairArray);
    }

    private boolean hasAssignPrivilege(ManagedObjectReference managedObjectReference) throws Exception {
        boolean bl = this._authService.checkPrivileges(new ManagedObjectReference[]{managedObjectReference}, new String[]{"Network.Assign"});
        return bl;
    }

    private boolean hasDsBrowsePrivilege(ManagedObjectReference managedObjectReference) throws Exception {
        boolean bl = this._authService.checkPrivileges(new ManagedObjectReference[]{managedObjectReference}, new String[]{PRIVILEGE_DATASTORE_BROWSE});
        return bl;
    }
}

