/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.navigator.impl;

import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vsphere.client.navigator.ObjectChainElement;
import com.vmware.vsphere.client.navigator.QuerySpecChainElement;
import com.vmware.vsphere.client.navigator.impl.QueryTransformer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PathRetriever {
    private static final Log _logger = LogFactory.getLog(PathRetriever.class);
    private int _queryExecutionCount = 0;
    public DataService dataService;

    public ObjectChainElement[] queryObjectPath(Object object, QuerySpecChainElement querySpecChainElement) {
        Collection<ObjectChainElement> collection = new ArrayList<ObjectChainElement>();
        collection.add(this.wrapIntoChainElement(object));
        while (querySpecChainElement != null && collection.size() > 0) {
            collection = this.reverseQueryRelatedObjMultiple(querySpecChainElement, collection);
            querySpecChainElement = querySpecChainElement.nextObject;
        }
        if (collection == null) {
            return new ObjectChainElement[0];
        }
        _logger.debug((Object)(this._queryExecutionCount + " query(s) executed."));
        return collection.toArray(new ObjectChainElement[0]);
    }

    private Collection<ObjectChainElement> reverseQueryRelatedObjMultiple(QuerySpecChainElement querySpecChainElement, Collection<ObjectChainElement> collection) {
        ArrayList<ObjectChainElement> arrayList = new ArrayList<ObjectChainElement>();
        QuerySpec querySpec = QueryTransformer.generateReverseQuery(querySpecChainElement, null);
        if (querySpec == null) {
            return arrayList;
        }
        for (ObjectChainElement objectChainElement : collection) {
            Collection<ObjectChainElement> collection2 = null;
            collection2 = querySpecChainElement.selfChaining ? this.queryRelatedObjSelfChained(querySpec, objectChainElement) : this.queryRelatedObj(querySpec, objectChainElement);
            if (collection2 == null) continue;
            arrayList.addAll(collection2);
        }
        return arrayList;
    }

    private Collection<ObjectChainElement> queryRelatedObjSelfChained(QuerySpec querySpec, ObjectChainElement objectChainElement) {
        LinkedList<ObjectChainElement> linkedList = new LinkedList<ObjectChainElement>();
        linkedList.add(objectChainElement);
        ArrayList<ObjectChainElement> arrayList = new ArrayList<ObjectChainElement>();
        int n = 0;
        ObjectChainElement objectChainElement2 = objectChainElement;
        while (objectChainElement2 != null) {
            Collection<ObjectChainElement> collection = this.queryRelatedObj(querySpec, objectChainElement2);
            arrayList.add(objectChainElement2);
            if (collection != null) {
                linkedList.addAll(collection);
            }
            objectChainElement2 = null;
            while (objectChainElement2 == null && n < linkedList.size()) {
                ListIterator<ObjectChainElement> listIterator = linkedList.listIterator(n);
                if (!listIterator.hasNext() || arrayList.contains(listIterator.next())) {
                    ++n;
                    continue;
                }
                objectChainElement2 = linkedList.get(n);
            }
        }
        return linkedList;
    }

    private Collection<ObjectChainElement> queryRelatedObj(QuerySpec querySpec, ObjectChainElement objectChainElement) {
        QueryTransformer.assignRelatedObjectToQuery(querySpec, objectChainElement.object);
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = this.dataService.getData(requestSpec);
        ++this._queryExecutionCount;
        if (response != null && response.resultSet.length > 0) {
            Object[] objectArray = this.extractObjects(response.resultSet[0]);
            return this.linkChainElements(objectArray, objectChainElement, querySpec);
        }
        return null;
    }

    private Collection<ObjectChainElement> linkChainElements(Object[] objectArray, ObjectChainElement objectChainElement, QuerySpec querySpec) {
        if (objectArray == null) {
            return null;
        }
        ArrayList<ObjectChainElement> arrayList = new ArrayList<ObjectChainElement>();
        for (Object object : objectArray) {
            if (!this.isExpectedType(object, querySpec)) continue;
            ObjectChainElement objectChainElement2 = this.wrapIntoChainElement(object);
            objectChainElement2.nextObject = objectChainElement;
            arrayList.add(objectChainElement2);
        }
        return arrayList;
    }

    private Object[] extractObjects(ResultSet resultSet) {
        if (resultSet.items == null || resultSet.items.length < 1) {
            return null;
        }
        Object[] objectArray = new Object[resultSet.items.length];
        for (int i = 0; i < resultSet.items.length; ++i) {
            ResultItem resultItem = resultSet.items[i];
            if (resultItem == null || resultItem.resourceObject == null) continue;
            objectArray[i] = resultItem.resourceObject;
        }
        return objectArray;
    }

    private boolean isExpectedType(Object object, QuerySpec querySpec) {
        if (object == null || querySpec == null || querySpec.resourceSpec == null || querySpec.resourceSpec.constraint == null || querySpec.resourceSpec.constraint.targetType == null) {
            return true;
        }
        String string = QueryUtil.getReferenceType((Object)object);
        String string2 = querySpec.resourceSpec.constraint.targetType;
        if (string.equals("VmwareDistributedVirtualSwitch") && string2.equals("DistributedVirtualSwitch")) {
            return true;
        }
        if (string.equals("VirtualApp") && string2.equals("ResourcePool")) {
            return true;
        }
        return querySpec.resourceSpec.constraint.targetType.equals(string);
    }

    private ObjectChainElement wrapIntoChainElement(Object object) {
        ObjectChainElement objectChainElement = new ObjectChainElement();
        objectChainElement.object = object;
        return objectChainElement;
    }
}

