/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.navigator.util;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.query.FacetSpec;
import com.vmware.vise.data.query.OrderingCriteria;
import com.vmware.vise.data.query.OrderingPropertySpec;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vsphere.client.navigator.util.OrderingPropertySpecBuilder;
import com.vmware.vsphere.client.navigator.util.PropertySpecBuilder;

public final class QuerySpecBuilder {
    private final PropertySpec[] _propertySpecs;
    private Constraint _constraint;
    private FacetSpec[] _facets;
    private OrderingPropertySpec[] _ordering;
    private Integer _maxResultCount;
    private Integer _offset;
    private String _name;

    private QuerySpecBuilder(PropertySpec[] propertySpecArray) {
        this._propertySpecs = propertySpecArray;
    }

    public static QuerySpecBuilder select(String ... stringArray) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = stringArray;
        return QuerySpecBuilder.select(propertySpec);
    }

    public static QuerySpecBuilder select(PropertySpec ... propertySpecArray) {
        return new QuerySpecBuilder(propertySpecArray);
    }

    public static QuerySpecBuilder select(PropertySpecBuilder ... propertySpecBuilderArray) {
        PropertySpec[] propertySpecArray = new PropertySpec[propertySpecBuilderArray.length];
        for (int i = 0; i < propertySpecBuilderArray.length; ++i) {
            propertySpecArray[i] = propertySpecBuilderArray[i].build();
        }
        return new QuerySpecBuilder(propertySpecArray);
    }

    public QuerySpecBuilder where(Constraint constraint) {
        this._constraint = constraint;
        return this;
    }

    public QuerySpecBuilder facets(PropertySpecBuilder ... propertySpecBuilderArray) {
        PropertySpec[] propertySpecArray = new PropertySpec[propertySpecBuilderArray.length];
        for (int i = 0; i < propertySpecBuilderArray.length; ++i) {
            propertySpecArray[i] = propertySpecBuilderArray[i].build();
        }
        return this.facets(propertySpecArray);
    }

    public QuerySpecBuilder facets(PropertySpec ... propertySpecArray) {
        this._facets = new FacetSpec[propertySpecArray.length];
        for (int i = 0; i < propertySpecArray.length; ++i) {
            this._facets[i] = new FacetSpec();
            this._facets[i].propSpec = propertySpecArray[i];
        }
        return this;
    }

    public QuerySpecBuilder orderBy(OrderingPropertySpec[] orderingPropertySpecArray) {
        this._ordering = orderingPropertySpecArray;
        return this;
    }

    public QuerySpecBuilder orderBy(String string, String string2) {
        OrderingPropertySpec orderingPropertySpec = new OrderingPropertySpec();
        orderingPropertySpec.type = string;
        orderingPropertySpec.relation = null;
        orderingPropertySpec.propertyNames = new String[]{string2};
        this._ordering = new OrderingPropertySpec[]{orderingPropertySpec};
        return this;
    }

    public QuerySpecBuilder orderBy(OrderingPropertySpecBuilder ... orderingPropertySpecBuilderArray) {
        this._ordering = new OrderingPropertySpec[orderingPropertySpecBuilderArray.length];
        for (int i = 0; i < orderingPropertySpecBuilderArray.length; ++i) {
            this._ordering[i] = orderingPropertySpecBuilderArray[i].build();
        }
        return this;
    }

    public QuerySpecBuilder offset(int n) {
        this._offset = n;
        return this;
    }

    public QuerySpecBuilder limit(int n) {
        this._maxResultCount = n;
        return this;
    }

    public QuerySpecBuilder queryName(String string) {
        this._name = string;
        return this;
    }

    public QuerySpec build() {
        QuerySpec querySpec = new QuerySpec();
        querySpec.name = this._name;
        querySpec.resourceSpec = new ResourceSpec();
        querySpec.resourceSpec.propertySpecs = this._propertySpecs;
        querySpec.resourceSpec.constraint = this._constraint;
        if (this._facets != null) {
            QuerySpecBuilder.resultSpec((QuerySpec)querySpec).facets = this._facets;
        }
        if (this._ordering != null) {
            QuerySpecBuilder.resultSpec((QuerySpec)querySpec).order = new OrderingCriteria();
            QuerySpecBuilder.resultSpec((QuerySpec)querySpec).order.orderingProperties = this._ordering;
        }
        if (this._maxResultCount != null) {
            QuerySpecBuilder.resultSpec((QuerySpec)querySpec).maxResultCount = this._maxResultCount;
        }
        if (this._offset != null) {
            QuerySpecBuilder.resultSpec((QuerySpec)querySpec).offset = this._offset;
        }
        return querySpec;
    }

    private static ResultSpec resultSpec(QuerySpec querySpec) {
        if (querySpec.resultSpec == null) {
            querySpec.resultSpec = new ResultSpec();
        }
        return querySpec.resultSpec;
    }
}

