/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.rp.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ResourcePool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ResourcePoolPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ResourcePoolPropertyProvider.class);
    private static final String RESOURCE_BUNDLE_NAME = "RpService";
    private DataService _dataService;

    public ResourcePoolPropertyProvider(DataService dataService) {
        this._dataService = dataService;
    }

    @type(value="ResourcePool,VirtualApp")
    public boolean getIsHostConnected(ManagedObjectReference managedObjectReference) throws Exception {
        String string;
        ManagedObjectReference managedObjectReference2 = this.getOwner(managedObjectReference);
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)managedObjectReference2, (String)(string = ClusterComputeResource.class.getSimpleName()))) {
            return true;
        }
        PropertyValue[] propertyValueArray = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)managedObjectReference2, (String)"host", (String)HostSystem.class.getSimpleName(), (String)"runtime.connectionState");
        return this.getIsConnectedFromQueryResult(propertyValueArray);
    }

    private ManagedObjectReference getOwner(ManagedObjectReference managedObjectReference) throws Exception {
        Object object = QueryUtil.getProperty((DataService)this._dataService, (Object)managedObjectReference, (String)"owner");
        if (object instanceof ManagedObjectReference) {
            return (ManagedObjectReference)object;
        }
        throw MixedUtil.getInvalidEntityFault();
    }

    private boolean getIsConnectedFromQueryResult(PropertyValue[] propertyValueArray) {
        if (propertyValueArray == null || propertyValueArray.length == 0) {
            _logger.warn((Object)"Unable to retrieve runtime.connectionState for host");
            return true;
        }
        Object object = propertyValueArray[0].value;
        if (!(object instanceof HostSystem.ConnectionState)) {
            _logger.warn((Object)"Unable to retrieve runtime.connectionState for host");
            return true;
        }
        HostSystem.ConnectionState connectionState = (HostSystem.ConnectionState)object;
        return connectionState == HostSystem.ConnectionState.connected;
    }

    @type(value="ResourcePool")
    public String getUniqueRpName(ManagedObjectReference managedObjectReference, String string) throws Exception {
        if (string == null) {
            return null;
        }
        String string2 = String.format(this.getLocalizedString("graftedFrom"), string, " ");
        int n = 1;
        PropertyValue[] propertyValueArray = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)managedObjectReference, (String)"resourcePool", (String)ResourcePool.class.getSimpleName(), (String)"name");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < propertyValueArray.length; ++i) {
            arrayList.add((String)propertyValueArray[i].value);
        }
        while (arrayList.contains(string2 + n)) {
            ++n;
        }
        return string2 + n;
    }

    private String getLocalizedString(String string) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)string, (ClassLoader)this.getClass().getClassLoader());
    }
}

