/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.search;

import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ModelMetadata;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.common.PathParam;
import com.vmware.vise.data.common.UnsupportedPropertyException;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.ResultItemComparator;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vise.metadata.Descriptor;
import com.vmware.vise.metadata.MetadataService;
import com.vmware.vise.metadata.MetadataServiceException;
import com.vmware.vise.metadata.PropertyDescriptor;
import com.vmware.vise.metadata.PropertyNodeDescriptor;
import com.vmware.vise.metadata.RelationshipDescriptor;
import com.vmware.vise.metadata.TypeDescriptor;
import com.vmware.vise.metadata.TypeNodeDescriptor;
import com.vmware.vise.metadata.util.MetadataUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.IdentityHashSet;
import com.vmware.vise.util.Predicate;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.collection.CollectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

final class MetadataProviderAdapter
implements DataProviderAdapter,
PropertyProviderBean {
    private static final String[] EMPTY_TYPES = new String[0];
    private static final PropertyNodeDescriptor[] EMPTY_PROPERTY_NODE_DESCRIPTORS = new PropertyNodeDescriptor[0];
    private static final String TYPE_DESCRIPTOR_NAME = TypeDescriptor.class.getSimpleName();
    private static final String PROPERTY_DESCRIPTOR_NAME = PropertyDescriptor.class.getSimpleName();
    private static final String RELATION_DESCRIPTOR_NAME = RelationshipDescriptor.class.getSimpleName();
    private static final String TYPE_NODE_DESCRIPTOR_NAME = TypeNodeDescriptor.class.getSimpleName();
    private static final String PROPERTY_NODE_DESCRIPTOR_NAME = PropertyNodeDescriptor.class.getSimpleName();
    private final MetadataService _metadataService;
    private final MetadataRetriever<TypeDescriptor> _typeRetriever = new MetadataRetriever<TypeDescriptor>(){

        public TypeDescriptor[] retrieve(String string) {
            return MetadataProviderAdapter.this._metadataService.getTypeMetadata(string);
        }
    };
    private final MetadataRetriever<PropertyDescriptor> _propertyRetriever = new MetadataRetriever<PropertyDescriptor>(){

        public PropertyDescriptor[] retrieve(String string) {
            return MetadataProviderAdapter.this._metadataService.getPropertyMetadata(string);
        }
    };
    private final MetadataRetriever<RelationshipDescriptor> _relationshipRetriever = new MetadataRetriever<RelationshipDescriptor>(){

        public RelationshipDescriptor[] retrieve(String string) {
            return MetadataProviderAdapter.this._metadataService.getRelationshipMetadata(string, null);
        }
    };

    public MetadataProviderAdapter(DataServiceExtensionRegistry dataServiceExtensionRegistry, MetadataService metadataService) {
        dataServiceExtensionRegistry.registerDataAdapter((DataProviderAdapter)this, this.getProvidedTypes());
        this._metadataService = metadataService;
    }

    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = this.processQuery(querySpecArray[i]);
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    @ModelMetadata(type={"*"}, property="{propertyPath*}.@typeInfo")
    public TypeDescriptor getTypeInfoForProperty(Object object, @PathParam(value="propertyPath") String string) {
        String[] stringArray;
        String string2 = QueryUtil.getReferenceType((Object)object);
        TypeDescriptor typeDescriptor = null;
        boolean bl = false;
        for (String string3 : stringArray = string.split("\\.")) {
            PropertyDescriptor[] propertyDescriptorArray = this._metadataService.getPropertyMetadata(string2);
            bl = false;
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                if (!string3.equals(propertyDescriptor.name)) continue;
                bl = true;
                TypeDescriptor[] typeDescriptorArray = this._metadataService.getTypeMetadata(propertyDescriptor.valueTypeName);
                typeDescriptor = this.getSingleTypeDescriptor(typeDescriptorArray, propertyDescriptor.valueTypeName);
                string2 = typeDescriptor.name;
                break;
            }
            if (!bl) break;
        }
        if (!bl || typeDescriptor == null) {
            throw new UnsupportedPropertyException();
        }
        return typeDescriptor;
    }

    @ModelMetadata(type={"*"}, property="{propertyPath*}.@propertyInfo")
    public PropertyDescriptor[] getPropertyInfoForProperty(Object object, @PathParam(value="propertyPath") String string) {
        TypeDescriptor typeDescriptor = this.getTypeInfoForProperty(object, string);
        return this._metadataService.getPropertyMetadata(typeDescriptor.name);
    }

    @ModelMetadata(type={"*"}, property="{propertyPath*}.@info")
    public TypeNodeDescriptor getMetadataTreeForProperty(Object object, @PathParam(value="propertyPath") String string) {
        TypeDescriptor typeDescriptor = this.getTypeInfoForProperty(object, string);
        if (typeDescriptor == null) {
            throw new UnsupportedPropertyException();
        }
        return this.getTypeTreeInfoForType(typeDescriptor);
    }

    private String[] getProvidedTypes() {
        return new String[]{TYPE_DESCRIPTOR_NAME, PROPERTY_DESCRIPTOR_NAME, RELATION_DESCRIPTOR_NAME, TYPE_NODE_DESCRIPTOR_NAME, PROPERTY_NODE_DESCRIPTOR_NAME};
    }

    private ResultSet processQuery(QuerySpec querySpec) {
        if (querySpec == null || querySpec.resourceSpec == null || querySpec.resourceSpec.constraint == null) {
            return null;
        }
        Constraint constraint = querySpec.resourceSpec.constraint;
        Collection<? extends Descriptor> collection = this.getFilteredDescriptors(constraint);
        ResultSet resultSet = this.buildResult(collection.toArray(new Descriptor[collection.size()]), querySpec.resourceSpec.propertySpecs);
        resultSet.queryName = querySpec.name;
        this.sortResult(resultSet, querySpec.resultSpec);
        ResultUtil.pageResult((ResultSet)resultSet, (ResultSpec)querySpec.resultSpec);
        return resultSet;
    }

    private Collection<? extends Descriptor> getFilteredDescriptors(Constraint constraint) {
        String string = constraint.targetType;
        if (string.equals(TYPE_DESCRIPTOR_NAME)) {
            Collection<TypeDescriptor> collection = this.getSpecificDescriptors(constraint, this._typeRetriever);
            return collection;
        }
        if (string.equals(PROPERTY_DESCRIPTOR_NAME)) {
            Collection<PropertyDescriptor> collection = this.getSpecificDescriptors(constraint, this._propertyRetriever);
            return collection;
        }
        if (string.equals(RELATION_DESCRIPTOR_NAME)) {
            Collection<RelationshipDescriptor> collection = this.getSpecificDescriptors(constraint, this._relationshipRetriever);
            return collection;
        }
        if (string.equals(TYPE_NODE_DESCRIPTOR_NAME)) {
            Collection<TypeDescriptor> collection = this.getSpecificDescriptors(constraint, this._typeRetriever);
            Collection<TypeNodeDescriptor> collection2 = this.toTypeNodeDescriptors(collection);
            return collection2;
        }
        if (string.equals(PROPERTY_NODE_DESCRIPTOR_NAME)) {
            Collection<PropertyDescriptor> collection = this.getSpecificDescriptors(constraint, this._propertyRetriever);
            Collection<PropertyNodeDescriptor> collection3 = this.toPropertyNodeDescriptors(collection);
            return collection3;
        }
        return Collections.emptySet();
    }

    private <T extends Descriptor> Collection<T> getSpecificDescriptors(Constraint constraint, MetadataRetriever<T> metadataRetriever) {
        String string = constraint.targetType;
        Object[] objectArray = this.gatherFilterTypesFromConstraint(constraint);
        Object object = new IdentityHashSet();
        if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) {
            Descriptor[] descriptorArray = metadataRetriever.retrieve(null);
            Collections.addAll(object, descriptorArray);
            object = this.filterByConstraint((Collection<T>)object, constraint, string);
            return object;
        }
        for (Object object2 : objectArray) {
            Descriptor[] descriptorArray = metadataRetriever.retrieve((String)object2);
            Collections.addAll(object, descriptorArray);
        }
        object = this.filterByConstraint((Collection<T>)object, constraint, string);
        return object;
    }

    private String[] gatherFilterTypesFromConstraint(Constraint constraint) {
        if (constraint == null) {
            return EMPTY_TYPES;
        }
        if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            return this.gatherFilterTypesFromPropertyConstraint(propertyConstraint);
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            if (!compositeConstraint.conjoiner.equals((Object)Conjoiner.OR)) {
                return EMPTY_TYPES;
            }
            HashSet hashSet = new HashSet();
            for (Constraint constraint2 : compositeConstraint.nestedConstraints) {
                String[] stringArray = this.gatherFilterTypesFromConstraint(constraint2);
                Collections.addAll(hashSet, stringArray);
            }
            return hashSet.toArray(new String[hashSet.size()]);
        }
        return EMPTY_TYPES;
    }

    private String[] gatherFilterTypesFromPropertyConstraint(PropertyConstraint propertyConstraint) {
        if (StringUtil.isNullOrEmpty((String)propertyConstraint.targetType) || StringUtil.isNullOrEmpty((String)propertyConstraint.propertyName)) {
            return EMPTY_TYPES;
        }
        if ((propertyConstraint.targetType.equals(PROPERTY_DESCRIPTOR_NAME) || propertyConstraint.targetType.equals(PROPERTY_NODE_DESCRIPTOR_NAME)) && propertyConstraint.propertyName.equals("valueTypeName") || (propertyConstraint.targetType.equals(TYPE_DESCRIPTOR_NAME) || propertyConstraint.targetType.equals(TYPE_NODE_DESCRIPTOR_NAME)) && propertyConstraint.propertyName.equals("name") || propertyConstraint.targetType.equals(RELATION_DESCRIPTOR_NAME) && propertyConstraint.propertyName.equals("sourceType")) {
            return new String[]{propertyConstraint.comparableValue.toString()};
        }
        return EMPTY_TYPES;
    }

    private Collection<TypeNodeDescriptor> toTypeNodeDescriptors(Collection<TypeDescriptor> collection) {
        HashSet<TypeNodeDescriptor> hashSet = new HashSet<TypeNodeDescriptor>(collection.size());
        for (TypeDescriptor typeDescriptor : collection) {
            TypeNodeDescriptor typeNodeDescriptor = this.getTypeTreeInfoForType(typeDescriptor);
            hashSet.add(typeNodeDescriptor);
        }
        return hashSet;
    }

    private Collection<PropertyNodeDescriptor> toPropertyNodeDescriptors(Collection<PropertyDescriptor> collection) {
        HashSet<PropertyNodeDescriptor> hashSet = new HashSet<PropertyNodeDescriptor>(collection.size());
        for (PropertyDescriptor propertyDescriptor : collection) {
            PropertyNodeDescriptor propertyNodeDescriptor = new PropertyNodeDescriptor(propertyDescriptor);
            hashSet.add(propertyNodeDescriptor);
        }
        return hashSet;
    }

    private TypeNodeDescriptor getTypeTreeInfoForType(TypeDescriptor typeDescriptor) {
        TypeNodeDescriptor typeNodeDescriptor = new TypeNodeDescriptor(typeDescriptor);
        PropertyDescriptor[] propertyDescriptorArray = this._metadataService.getPropertyMetadata(typeDescriptor.name);
        if (propertyDescriptorArray.length > 0) {
            LinkedList<PropertyNodeDescriptor> linkedList = new LinkedList<PropertyNodeDescriptor>();
            for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray) {
                PropertyNodeDescriptor propertyNodeDescriptor = new PropertyNodeDescriptor(propertyDescriptor);
                propertyNodeDescriptor.valueType = this.getTypeTreeInfoForProperty(propertyDescriptor);
                linkedList.add(propertyNodeDescriptor);
            }
            typeNodeDescriptor.properties = linkedList.toArray(new PropertyNodeDescriptor[linkedList.size()]);
        } else {
            typeNodeDescriptor.properties = EMPTY_PROPERTY_NODE_DESCRIPTORS;
        }
        return typeNodeDescriptor;
    }

    private TypeNodeDescriptor getTypeTreeInfoForProperty(PropertyDescriptor propertyDescriptor) {
        if (propertyDescriptor == null) {
            return null;
        }
        TypeDescriptor[] typeDescriptorArray = this._metadataService.getTypeMetadata(propertyDescriptor.valueTypeName);
        TypeDescriptor typeDescriptor = this.getSingleTypeDescriptor(typeDescriptorArray, propertyDescriptor.valueTypeName);
        return this.getTypeTreeInfoForType(typeDescriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private TypeDescriptor getSingleTypeDescriptor(TypeDescriptor[] typeDescriptorArray, String string) {
        if (typeDescriptorArray == null) throw new MetadataServiceException("The lookup for type '" + string + "' returned null. This should never happen.");
        if (typeDescriptorArray.length == 1) {
            return typeDescriptorArray[0];
        }
        if (typeDescriptorArray.length != 0) throw new MetadataServiceException("Found more than one type definition for type '" + string + "'.");
        TypeDescriptor typeDescriptor = new TypeDescriptor();
        typeDescriptor.name = typeDescriptor.name = string;
        return typeDescriptor;
    }

    private <T extends Descriptor> Collection<T> filterByConstraint(Collection<T> collection, Constraint constraint, String string) {
        if (!constraint.targetType.equals(string)) {
            throw new UnsupportedOperationException(String.format("Invalid constraint targetType:%1$s", constraint.targetType));
        }
        if (constraint instanceof CompositeConstraint) {
            CompositeConstraint compositeConstraint = (CompositeConstraint)constraint;
            return this.filterByCompositeConstraint(collection, compositeConstraint, string);
        }
        if (constraint instanceof PropertyConstraint) {
            PropertyConstraint propertyConstraint = (PropertyConstraint)constraint;
            return this.filterByPropertyConstraint(collection, propertyConstraint);
        }
        if (constraint.getClass().equals(Constraint.class)) {
            return collection;
        }
        throw new UnsupportedOperationException(String.format("Unsupported constraint:%1$s", constraint.getClass().getSimpleName()));
    }

    private <T extends Descriptor> Collection<T> filterByCompositeConstraint(Collection<T> collection, CompositeConstraint compositeConstraint, String string) {
        Collection<Object> collection2 = new HashSet();
        for (Constraint constraint : compositeConstraint.nestedConstraints) {
            Collection<T> collection3;
            if (compositeConstraint.conjoiner == Conjoiner.AND) {
                collection3 = this.filterByConstraint(collection, constraint, string);
                if (collection2.size() <= 0) {
                    collection2 = collection3;
                    continue;
                }
                collection2.retainAll(collection3);
                continue;
            }
            if (compositeConstraint.conjoiner != Conjoiner.OR) continue;
            collection3 = this.filterByConstraint(collection, constraint, string);
            collection2.addAll(collection3);
        }
        return collection2;
    }

    private <T extends Descriptor> Collection<T> filterByPropertyConstraint(Collection<T> collection, final PropertyConstraint propertyConstraint) {
        Predicate predicate = new Predicate<T>(){

            public boolean evaluate(T t) {
                PropertyRetriever propertyRetriever = new PropertyRetriever(t);
                Object object = propertyRetriever.retrieve(propertyConstraint.propertyName);
                if (object == null) {
                    return false;
                }
                boolean bl = false;
                if (propertyConstraint.comparator.equals((Object)Comparator.EQUALS)) {
                    bl = object.equals(propertyConstraint.comparableValue);
                } else if (propertyConstraint.comparator.equals((Object)Comparator.NOT_EQUALS)) {
                    bl = !object.equals(propertyConstraint.comparableValue);
                } else if (propertyConstraint.comparator.equals((Object)Comparator.CONTAINS)) {
                    bl = object.toString().contains(propertyConstraint.comparableValue.toString());
                } else if (propertyConstraint.comparator.equals((Object)Comparator.STARTS_WITH)) {
                    bl = object.toString().startsWith(propertyConstraint.comparableValue.toString());
                } else if (propertyConstraint.comparator.equals((Object)Comparator.ENDS_WITH)) {
                    bl = object.toString().endsWith(propertyConstraint.comparableValue.toString());
                }
                return bl;
            }
        };
        return CollectionUtil.filter(collection, (Predicate)predicate);
    }

    private ResultSet buildResult(Descriptor[] descriptorArray, PropertySpec[] propertySpecArray) {
        ResultSet resultSet = new ResultSet();
        ResultItem[] resultItemArray = this.createResultItems(descriptorArray, propertySpecArray);
        resultSet.items = resultItemArray;
        resultSet.totalMatchedObjectCount = descriptorArray.length;
        return resultSet;
    }

    private void sortResult(ResultSet resultSet, ResultSpec resultSpec) {
        if (resultSpec == null || resultSpec.order == null || ArrayUtil.isNullOrEmpty((Object[])resultSpec.order.orderingProperties) || resultSet == null || ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
            return;
        }
        Arrays.sort(resultSet.items, new ResultItemComparator(resultSpec.order));
    }

    private ResultItem[] createResultItems(Descriptor[] descriptorArray, PropertySpec[] propertySpecArray) {
        ResultItem[] resultItemArray = new ResultItem[descriptorArray.length];
        for (int i = 0; i < descriptorArray.length; ++i) {
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = MetadataUtil.toProviderRef((Descriptor)descriptorArray[i]);
            resultItem.properties = this.createProperties(descriptorArray[i], propertySpecArray);
            resultItemArray[i] = resultItem;
        }
        return resultItemArray;
    }

    private PropertyValue[] createProperties(Descriptor descriptor, PropertySpec[] propertySpecArray) {
        ArrayList<PropertyValue> arrayList = new ArrayList<PropertyValue>();
        for (PropertySpec propertySpec : propertySpecArray) {
            for (String string : propertySpec.propertyNames) {
                PropertyValue propertyValue;
                if (string.equals("_content")) {
                    propertyValue = this.createProperty(descriptor, "_content", descriptor);
                    arrayList.add(propertyValue);
                    continue;
                }
                propertyValue = this.getProperty(descriptor, string);
                arrayList.add(propertyValue);
            }
        }
        return arrayList.toArray(new PropertyValue[arrayList.size()]);
    }

    private PropertyValue createProperty(Descriptor descriptor, Field field) {
        Object object = null;
        try {
            object = field.get(descriptor);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return this.createProperty(descriptor, field.getName(), object);
    }

    private PropertyValue createProperty(Descriptor descriptor, String string, Object object) {
        PropertyValue propertyValue = new PropertyValue();
        propertyValue.resourceObject = MetadataUtil.toProviderRef((Descriptor)descriptor);
        propertyValue.propertyName = string;
        propertyValue.value = object;
        return propertyValue;
    }

    private PropertyValue getProperty(Descriptor descriptor, String string) {
        Field field = null;
        try {
            field = descriptor.getClass().getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return field == null ? null : this.createProperty(descriptor, field);
    }

    private static interface MetadataRetriever<T extends Descriptor> {
        public T[] retrieve(String var1);
    }

    private class PropertyRetriever<T> {
        private final T _obj;

        public PropertyRetriever(T t) {
            if (t == null) {
                throw new IllegalArgumentException();
            }
            this._obj = t;
        }

        private Field getPropertyInfo(String string) {
            Field field = null;
            try {
                field = this._obj.getClass().getField(string);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return field;
        }

        public Object retrieve(String string) {
            if (StringUtil.isNullOrEmpty((String)string)) {
                throw new IllegalArgumentException();
            }
            Field field = this.getPropertyInfo(string);
            if (field == null) {
                return null;
            }
            Object object = null;
            try {
                object = field.get(this._obj);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            return object;
        }
    }
}

