/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.impl;

import com.vmware.vim.binding.vim.TaskFilterSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public class ClientTaskFilter {
    public static final int UNSPECIFIED_COUNT = -1;
    private boolean _recentTasksOnly;
    private Set<TaskState> _taskStates;
    private Set<String> _userNames;
    private Set<String> _rootTaskKeys;
    private ManagedObjectReference _taskTargetEntity;
    private int _page = -1;
    private int _pageSize = 50;

    public void setPage(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("page number cannot be " + n);
        }
        this._page = n;
    }

    public int getPage() {
        return this._page;
    }

    public void setPageSize(int n) {
        this._pageSize = n;
    }

    public int getPageSize() {
        return this._pageSize;
    }

    public void setRecentTasks(boolean bl) {
        this._recentTasksOnly = bl;
    }

    public boolean recentTasksOnly() {
        return this._recentTasksOnly;
    }

    public void setEntity(ManagedObjectReference managedObjectReference) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{managedObjectReference});
        this._taskTargetEntity = managedObjectReference;
    }

    public void addRootTaskKey(String string) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{string});
        if (this._rootTaskKeys == null) {
            this._rootTaskKeys = new HashSet<String>();
        }
        this._rootTaskKeys.addAll(Arrays.asList(string));
    }

    public void addTaskStates(TaskState taskState) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{taskState});
        if (this._taskStates == null) {
            this._taskStates = EnumSet.of(taskState);
        } else {
            this._taskStates.add(taskState);
        }
    }

    public void addUserNames(TaskFilterSpec.ByUsername byUsername) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{byUsername});
        if (this._userNames == null) {
            this._userNames = new HashSet<String>();
        }
        for (String string : byUsername.userList) {
            this._userNames.add(string);
        }
    }

    public boolean accepts(ClientTaskInfo clientTaskInfo) {
        ManagedObjectReference managedObjectReference;
        if (this._taskTargetEntity != null && clientTaskInfo.entity instanceof ManagedObjectReference && !ManagedObjectUtil.areEqual((ManagedObjectReference)(managedObjectReference = (ManagedObjectReference)clientTaskInfo.entity), (ManagedObjectReference)this._taskTargetEntity).booleanValue()) {
            return false;
        }
        if (this._taskStates != null && !this._taskStates.isEmpty() && !this._taskStates.contains(clientTaskInfo.state)) {
            return false;
        }
        if (this._userNames != null && !this._userNames.isEmpty() && !this._userNames.contains(clientTaskInfo.initiator)) {
            return false;
        }
        return this._rootTaskKeys == null || this._rootTaskKeys.isEmpty() || this._rootTaskKeys.contains(clientTaskInfo.rootTaskKey) || clientTaskInfo.rootTaskKey == null && this._rootTaskKeys.contains(clientTaskInfo.key);
    }
}

