/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.task.ClientTaskCreationSpec;
import com.vmware.vsphere.client.task.ClientTaskStateSpec;
import com.vmware.vsphere.client.task.TaskRegistry;
import com.vmware.vsphere.client.task.impl.ParametrizedMessageException;
import com.vmware.vsphere.client.task.impl.TaskUtil;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClientTaskMutationProvider
implements MutationProvider {
    private static final Log _logger;
    private static final Set<String> _clientTaskInfoFieldNames;
    private final TaskRegistry _taskRegistry;
    private final DataService _dataService;

    public ClientTaskMutationProvider(DataService dataService, TaskRegistry taskRegistry) {
        assert (dataService != null && taskRegistry != null);
        this._dataService = dataService;
        this._taskRegistry = taskRegistry;
    }

    public OperationResult add(ClientTaskCreationSpec clientTaskCreationSpec) {
        ManagedObjectReference managedObjectReference;
        OperationResult operationResult = new OperationResult();
        String string = this.validateCreationSpec(clientTaskCreationSpec);
        if (string != null) {
            _logger.error((Object)("Invalid task creation spec: " + string));
            String string2 = TaskUtil.getLocalizedString(string);
            operationResult.error = new Exception(string2);
            return operationResult;
        }
        ClientTaskInfo clientTaskInfo = new ClientTaskInfo();
        try {
            this.setTaskValues(clientTaskInfo, clientTaskCreationSpec);
        }
        catch (Exception exception) {
            _logger.error((Object)("Exception copying values to task: " + exception));
            operationResult.error = new Exception(exception.getMessage());
            return operationResult;
        }
        if (StringUtil.isNullOrEmpty((String)clientTaskInfo.entityName)) {
            assert (clientTaskInfo.entity instanceof ManagedObjectReference);
            try {
                clientTaskInfo.entityName = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)clientTaskInfo.entity, (String)"name");
            }
            catch (Exception exception) {
                operationResult.error = exception;
                return operationResult;
            }
        }
        if (StringUtil.isNullOrEmpty((String)clientTaskInfo.entityType)) {
            assert (clientTaskInfo.entity instanceof ManagedObjectReference);
            clientTaskInfo.entityType = ((ManagedObjectReference)clientTaskInfo.entity).getType();
        }
        if (clientTaskCreationSpec.entity instanceof ManagedObjectReference) {
            managedObjectReference = (ManagedObjectReference)clientTaskInfo.entity;
            if (StringUtil.isNullOrEmpty((String)clientTaskInfo.serverGuid)) {
                clientTaskInfo.serverGuid = managedObjectReference.getServerGuid();
            } else if (!managedObjectReference.getServerGuid().equals(clientTaskInfo.serverGuid)) {
                _logger.warn((Object)"TaskCreationSpec server GUID does not match task entity");
            }
        }
        clientTaskInfo.queueTime = new Date();
        if (clientTaskCreationSpec.state != TaskState.QUEUED) {
            clientTaskInfo.startTime = clientTaskInfo.queueTime;
        }
        if (clientTaskCreationSpec.state == TaskState.CANCELED || clientTaskCreationSpec.state == TaskState.ERROR || clientTaskCreationSpec.state == TaskState.SUCCESS) {
            clientTaskInfo.completionTime = clientTaskInfo.queueTime;
        }
        this.setTaskException(clientTaskInfo, clientTaskCreationSpec);
        clientTaskInfo.service = VcServiceUtil.getServiceName((String)clientTaskInfo.serverGuid);
        clientTaskInfo.source = TaskUtil.getLocalizedString("source.vCenter");
        clientTaskInfo.initiator = (String)SessionUtil.getData((String)"USER_NAME");
        managedObjectReference = null;
        managedObjectReference = clientTaskCreationSpec.terminalState == null ? this._taskRegistry.addTask(clientTaskInfo) : this._taskRegistry.addTask(clientTaskInfo, clientTaskCreationSpec.terminalState);
        operationResult.result = managedObjectReference;
        return operationResult;
    }

    public OperationResult apply(String string, ClientTaskStateSpec clientTaskStateSpec) {
        OperationResult operationResult = new OperationResult();
        if (StringUtil.isNullOrEmpty((String)string)) {
            _logger.error((Object)"Task key in state spec is null or empty");
            String string2 = TaskUtil.getLocalizedString("error.clientTaskMutationProvider.update.spec.taskKeyInvalid");
            operationResult.error = new Exception(string2);
            return operationResult;
        }
        ClientTaskInfo clientTaskInfo = this._taskRegistry.getTask(string);
        if (clientTaskInfo == null) {
            _logger.error((Object)"Task key in state spec does not match an existing task");
            String string3 = TaskUtil.getLocalizedString("error.clientTaskMutationProvider.update.spec.taskNotFound");
            operationResult.error = new Exception(string3);
            return operationResult;
        }
        if ((TaskState.RUNNING.equals((Object)clientTaskInfo.state) || TaskState.QUEUED.equals((Object)clientTaskInfo.state)) && TaskState.CANCELED.equals((Object)clientTaskStateSpec.state)) {
            Closeable closeable;
            clientTaskInfo.state = TaskState.CANCELED;
            this._taskRegistry.updateTask(clientTaskInfo);
            Pair<Future<?>, Closeable> pair = TaskUtil.getClientTaskFutureCloseablePair(string);
            if (pair == null) {
                return operationResult;
            }
            Future future = (Future)pair.first;
            if (future != null) {
                future.cancel(true);
            }
            if ((closeable = (Closeable)pair.second) != null) {
                try {
                    closeable.close();
                }
                catch (Exception exception) {
                    _logger.error((Object)"The closeable cannot be closed.", (Throwable)exception);
                }
            }
            return operationResult;
        }
        try {
            this.setTaskValues(clientTaskInfo, clientTaskStateSpec);
        }
        catch (Exception exception) {
            _logger.error((Object)("Exception copying values to task: " + exception));
            operationResult.error = new Exception(exception.getMessage());
            return operationResult;
        }
        this.setTaskException(clientTaskInfo, clientTaskStateSpec);
        if (clientTaskInfo.completionTime == null && this.isInFinishedState(clientTaskInfo)) {
            clientTaskInfo.completionTime = new Date();
        }
        this._taskRegistry.updateTask(clientTaskInfo);
        return operationResult;
    }

    private void setTaskValues(ClientTaskInfo clientTaskInfo, Object object) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field[] fieldArray;
        for (Field field : fieldArray = object.getClass().getFields()) {
            Field field2;
            String string = field.getName();
            if (!_clientTaskInfoFieldNames.contains(string) || !(field2 = ClientTaskInfo.class.getField(string)).getType().equals(field.getType())) continue;
            Object object2 = field.get(object);
            field2.set(clientTaskInfo, object2);
        }
    }

    private void setTaskException(ClientTaskInfo clientTaskInfo, ClientTaskStateSpec clientTaskStateSpec) {
        if (clientTaskInfo.state == TaskState.ERROR && !StringUtil.isNullOrEmpty((String)clientTaskStateSpec.errorMessage)) {
            clientTaskInfo.error = ArrayUtil.isNullOrEmpty((Object[])clientTaskStateSpec.errorMessageParams) ? new Exception(clientTaskStateSpec.errorMessage) : new ParametrizedMessageException(clientTaskStateSpec.errorMessage, clientTaskStateSpec.errorMessageParams);
        }
    }

    private boolean isInFinishedState(ClientTaskInfo clientTaskInfo) {
        return clientTaskInfo.state == TaskState.CANCELED || clientTaskInfo.state == TaskState.ERROR || clientTaskInfo.state == TaskState.SUCCESS;
    }

    private String validateCreationSpec(ClientTaskCreationSpec clientTaskCreationSpec) {
        String string = null;
        if (StringUtil.isNullOrEmpty((String)clientTaskCreationSpec.description)) {
            string = "error.clientTaskMutationProvider.create.spec.missingDescription";
        } else if (clientTaskCreationSpec.entity == null) {
            string = "error.clientTaskMutationProvider.create.spec.missingEntity";
        } else if (clientTaskCreationSpec.state == null) {
            string = "error.clientTaskMutationProvider.create.spec.missingState";
        } else if (!(clientTaskCreationSpec.entity instanceof ManagedObjectReference)) {
            if (StringUtil.isNullOrEmpty((String)clientTaskCreationSpec.serverGuid)) {
                string = "error.clientTaskMutationProvider.create.spec.serverGuid";
            } else if (StringUtil.isNullOrEmpty((String)clientTaskCreationSpec.entityName)) {
                string = "error.clientTaskMutationProvider.create.spec.missingEntityName";
            } else if (StringUtil.isNullOrEmpty((String)clientTaskCreationSpec.entityType)) {
                string = "error.clientTaskMutationProvider.create.spec.missingEntityType";
            }
        } else {
            ManagedObjectReference managedObjectReference = (ManagedObjectReference)clientTaskCreationSpec.entity;
            if (!StringUtil.isNullOrEmpty((String)clientTaskCreationSpec.entityType) && !clientTaskCreationSpec.entityType.equals(managedObjectReference.getType())) {
                string = "error.clientTaskMutationProvider.create.spec.badEntityType";
            }
        }
        return string;
    }

    static {
        Field[] fieldArray;
        _logger = LogFactory.getLog(ClientTaskMutationProvider.class);
        _clientTaskInfoFieldNames = new HashSet<String>();
        for (Field field : fieldArray = ClientTaskInfo.class.getDeclaredFields()) {
            _clientTaskInfoFieldNames.add(field.getName());
        }
    }
}

