/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.task.impl;

import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.monitor.TaskState;
import com.vmware.vise.security.UserSessionListener;
import com.vmware.vise.util.ObjectUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vsphere.client.task.TaskIteratorSpec;
import com.vmware.vsphere.client.task.TaskRegistry;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class ClientTaskRegistry
implements TaskRegistry,
UserSessionListener {
    private static final String TASK_MOREF_TYPE = "ClientTask";
    public static final long MAX_TASK_AGE_IN_MILLIS = 31536000000L;
    public static final int MAX_NUMBER_OF_TASKS = 10000;
    private static final TaskKeyToken MIN_TASK_KEY_TOKEN = new TaskKeyToken(0L, 0L);
    private static final TaskKeyToken MAX_TASK_KEY_TOKEN = new TaskKeyToken(Long.MAX_VALUE, Long.MAX_VALUE);
    private static final Log _logger = LogFactory.getLog(ClientTaskRegistry.class);
    private final ReadWriteLock _readWriteLock = new ReentrantReadWriteLock();
    private final Lock _readLock = this._readWriteLock.readLock();
    private final Lock _writeLock = this._readWriteLock.writeLock();
    private final AtomicLong _idCounter = new AtomicLong(0L);
    @GuardedBy(value="_readWriteLock")
    private final NavigableMap<TaskKeyToken, ImmutableTaskInfo> _registry = new TreeMap<TaskKeyToken, ImmutableTaskInfo>();
    @GuardedBy(value="_readWriteLock")
    private final Map<String, Map<TaskKeyToken, TaskState>> _terminalStatesBySessionId = new HashMap<String, Map<TaskKeyToken, TaskState>>();
    @GuardedBy(value="_readWriteLock")
    private final Map<TaskKeyToken, String> _sessionIdByTaskKey = new HashMap<TaskKeyToken, String>();

    @Override
    public ClientTaskInfo addTask(ClientTaskInfo clientTaskInfo) throws IllegalArgumentException {
        ClientTaskInfo clientTaskInfo2 = this.addTaskInternal(clientTaskInfo, null, null);
        return clientTaskInfo2;
    }

    @Override
    public ClientTaskInfo addTask(ClientTaskInfo clientTaskInfo, TaskState taskState) throws IllegalArgumentException {
        if (taskState == null) {
            throw new IllegalArgumentException("terminalState is null");
        }
        HttpSession httpSession = null;
        try {
            httpSession = SessionUtil.getHttpSession();
        }
        catch (Exception exception) {
            _logger.warn((Object)("Cannot get session: " + exception.getMessage()));
            _logger.debug((Object)"Trace:", (Throwable)exception);
        }
        String string = httpSession != null ? httpSession.getId() : null;
        ClientTaskInfo clientTaskInfo2 = this.addTaskInternal(clientTaskInfo, string, taskState);
        return clientTaskInfo2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClientTaskInfo addTaskInternal(ClientTaskInfo clientTaskInfo, String string, TaskState taskState) throws IllegalArgumentException {
        Object object;
        if (clientTaskInfo == null) {
            throw new IllegalArgumentException("Attempt to add a null task is illegal.");
        }
        ClientTaskInfo clientTaskInfo2 = (ClientTaskInfo)ObjectUtil.shallowCopy((Object)clientTaskInfo, ClientTaskInfo.class);
        String string2 = clientTaskInfo2.key;
        if (string2 != null) {
            throw new IllegalArgumentException("If the task has a key then it means the task has already been added.");
        }
        TaskKeyToken taskKeyToken = this.getKeyToken(clientTaskInfo);
        clientTaskInfo2.key = ClientTaskRegistry.generateKey(taskKeyToken._timeStamp, taskKeyToken._sequenceNr);
        if (clientTaskInfo2.taskRef == null || !(clientTaskInfo2.taskRef instanceof ManagedObjectReference)) {
            clientTaskInfo2.taskRef = ClientTaskRegistry.generateTaskReference(clientTaskInfo2.key, clientTaskInfo2.serverGuid);
        }
        ImmutableTaskInfo immutableTaskInfo = new ImmutableTaskInfo(clientTaskInfo2);
        Set<TaskKeyToken> set = null;
        this._writeLock.lock();
        try {
            this._registry.put(taskKeyToken, immutableTaskInfo);
            if (string != null) {
                this._sessionIdByTaskKey.put(taskKeyToken, string);
                object = this._terminalStatesBySessionId.get(string);
                if (object == null) {
                    object = new HashMap();
                    this._terminalStatesBySessionId.put(string, (Map<TaskKeyToken, TaskState>)object);
                }
                object.put(taskKeyToken, taskState);
            }
            set = this.removeExcessAndExpiredTasks();
        }
        finally {
            this._writeLock.unlock();
        }
        if (set.contains(taskKeyToken)) {
            return null;
        }
        object = immutableTaskInfo.getClientTaskInfo();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientTaskInfo getTask(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null task key.");
        }
        TaskKeyToken taskKeyToken = ClientTaskRegistry.getTaskKeyToken(string);
        ImmutableTaskInfo immutableTaskInfo = null;
        this._readLock.lock();
        try {
            immutableTaskInfo = (ImmutableTaskInfo)this._registry.get(taskKeyToken);
        }
        finally {
            this._readLock.unlock();
        }
        if (immutableTaskInfo == null) {
            return null;
        }
        ClientTaskInfo clientTaskInfo = immutableTaskInfo.getClientTaskInfo();
        return clientTaskInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateTask(ClientTaskInfo clientTaskInfo) {
        if (clientTaskInfo == null) {
            throw new IllegalArgumentException("Cannot update from a null task");
        }
        ImmutableTaskInfo immutableTaskInfo = new ImmutableTaskInfo(clientTaskInfo);
        String string = (String)immutableTaskInfo.getFieldValue("key");
        if (string == null) {
            throw new IllegalArgumentException("Cannot update a task not in the registry.");
        }
        TaskKeyToken taskKeyToken = ClientTaskRegistry.getTaskKeyToken(string);
        HttpSession httpSession = null;
        try {
            httpSession = SessionUtil.getHttpSession();
        }
        catch (Exception exception) {
            _logger.warn((Object)("Cannot get http session. " + exception.getMessage()));
            _logger.debug((Object)"Trace:", (Throwable)exception);
        }
        String string2 = httpSession != null ? httpSession.getId() : null;
        this._writeLock.lock();
        try {
            ImmutableTaskInfo immutableTaskInfo2 = (ImmutableTaskInfo)this._registry.get(taskKeyToken);
            if (immutableTaskInfo2 == null) {
                throw new IllegalArgumentException("The specified task is not registered");
            }
            TaskState taskState = (TaskState)immutableTaskInfo2.getFieldValue("state");
            if (taskState != clientTaskInfo.state && (clientTaskInfo.state == TaskState.CANCELED || clientTaskInfo.state == TaskState.SUCCESS || clientTaskInfo.state == TaskState.ERROR)) {
                Map<TaskKeyToken, TaskState> map = this._terminalStatesBySessionId.get(string2);
                if (map != null) {
                    map.remove(taskKeyToken);
                    if (map.isEmpty()) {
                        this._terminalStatesBySessionId.remove(string2);
                    }
                }
                this._sessionIdByTaskKey.remove(taskKeyToken);
            }
            this._registry.put(taskKeyToken, immutableTaskInfo);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<ClientTaskInfo> iterator(TaskIteratorSpec taskIteratorSpec) {
        Object object;
        ValidationUtil.paramsNotNull((Object[])new Object[]{taskIteratorSpec});
        TaskKeyToken taskKeyToken = MIN_TASK_KEY_TOKEN;
        Long l = taskIteratorSpec.getMaxAge();
        if (l != null) {
            taskKeyToken = new TaskKeyToken(l, 0L);
        }
        TaskKeyToken taskKeyToken2 = MAX_TASK_KEY_TOKEN;
        Long l2 = taskIteratorSpec.getMinAge();
        if (l2 != null) {
            taskKeyToken2 = new TaskKeyToken(l2, Long.MAX_VALUE);
        }
        boolean bl = false;
        Collection collection = null;
        this._readLock.lock();
        try {
            if (this._registry.isEmpty()) {
                Iterator<ClientTaskInfo> iterator = Collections.emptyIterator();
                return iterator;
            }
            object = this._registry.subMap(taskKeyToken, bl, taskKeyToken2, bl);
            collection = TaskIteratorSpec.Direction.ASCENDING == taskIteratorSpec.getDirection() ? object.descendingMap().values() : object.values();
        }
        finally {
            this._readLock.unlock();
        }
        object = new ArrayList(collection.size());
        for (ImmutableTaskInfo immutableTaskInfo : collection) {
            object.add(immutableTaskInfo.getClientTaskInfo());
        }
        Iterator<ClientTaskInfo> iterator = object.iterator();
        return iterator;
    }

    @Override
    public boolean contains(ClientTaskInfo clientTaskInfo) throws NullPointerException {
        if (clientTaskInfo == null) {
            throw new NullPointerException("The task is null");
        }
        String string = clientTaskInfo.key;
        if (string == null) {
            return false;
        }
        boolean bl = this.doContains(string);
        return bl;
    }

    @Override
    public boolean contains(String string) throws IllegalArgumentException {
        if (string == null) {
            throw new NullPointerException("The taskKey is null");
        }
        boolean bl = this.doContains(string);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doContains(String string) {
        assert (string != null);
        TaskKeyToken taskKeyToken = ClientTaskRegistry.getTaskKeyToken(string);
        assert (taskKeyToken != null);
        this._readLock.lock();
        try {
            ImmutableTaskInfo immutableTaskInfo = (ImmutableTaskInfo)this._registry.get(taskKeyToken);
            boolean bl = immutableTaskInfo != null;
            return bl;
        }
        finally {
            this._readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        this._readLock.lock();
        try {
            int n = this._registry.size();
            return n;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void sessionStarted(HttpSessionEvent httpSessionEvent, Locale locale) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sessionEnded(HttpSessionEvent httpSessionEvent) throws Exception {
        if (httpSessionEvent == null) {
            return;
        }
        HttpSession httpSession = httpSessionEvent.getSession();
        if (httpSession == null) {
            return;
        }
        String string = httpSession.getId();
        this._writeLock.lock();
        try {
            Map<TaskKeyToken, TaskState> map = this._terminalStatesBySessionId.get(string);
            if (map == null || map.isEmpty()) {
                return;
            }
            for (Map.Entry<TaskKeyToken, TaskState> entry : map.entrySet()) {
                TaskState taskState = entry.getValue();
                TaskKeyToken taskKeyToken = entry.getKey();
                ImmutableTaskInfo immutableTaskInfo = (ImmutableTaskInfo)this._registry.get(taskKeyToken);
                TaskState taskState2 = (TaskState)immutableTaskInfo.getFieldValue("state");
                if (taskState2 == TaskState.CANCELED || taskState2 == TaskState.ERROR || taskState2 == TaskState.SUCCESS) {
                    _logger.error((Object)("Task registered for session termination had illegal state '" + taskState2 + "' when session ended."));
                    continue;
                }
                ClientTaskInfo clientTaskInfo = immutableTaskInfo.getClientTaskInfo();
                clientTaskInfo.state = taskState;
                clientTaskInfo.completionTime = new Date();
                if (taskState == TaskState.CANCELED && !clientTaskInfo.cancelable) {
                    clientTaskInfo.cancelable = true;
                }
                ImmutableTaskInfo immutableTaskInfo2 = new ImmutableTaskInfo(clientTaskInfo);
                this._registry.put(taskKeyToken, immutableTaskInfo2);
                this._sessionIdByTaskKey.remove(taskKeyToken);
            }
            this._terminalStatesBySessionId.remove(string);
        }
        finally {
            this._writeLock.unlock();
        }
    }

    private TaskKeyToken getKeyToken(ClientTaskInfo clientTaskInfo) {
        long l = 0L;
        Date date = clientTaskInfo.queueTime;
        l = date != null ? date.getTime() : System.currentTimeMillis();
        long l2 = this._idCounter.incrementAndGet();
        TaskKeyToken taskKeyToken = new TaskKeyToken(l, l2);
        return taskKeyToken;
    }

    private static String generateKey(long l, long l2) {
        StringBuilder stringBuilder = new StringBuilder(TASK_MOREF_TYPE);
        stringBuilder.append('-');
        stringBuilder.append(l);
        stringBuilder.append('-');
        stringBuilder.append(l2);
        return stringBuilder.toString();
    }

    private static ManagedObjectReference generateTaskReference(String string, String string2) {
        return new ManagedObjectReference(TASK_MOREF_TYPE, string, string2);
    }

    private static TaskKeyToken getTaskKeyToken(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null key");
        }
        String[] stringArray = string.split("-");
        if (stringArray == null || stringArray.length != 3) {
            throw new IllegalArgumentException("Invalid key format: " + string);
        }
        String string2 = stringArray[1];
        String string3 = stringArray[2];
        long l = Long.valueOf(string2);
        long l2 = Long.valueOf(string3);
        TaskKeyToken taskKeyToken = new TaskKeyToken(l, l2);
        return taskKeyToken;
    }

    @GuardedBy(value="_writeLock")
    private Set<TaskKeyToken> removeExcessAndExpiredTasks() {
        TaskKeyToken taskKeyToken2;
        if (this._registry.isEmpty()) {
            return Collections.emptySet();
        }
        long l = System.currentTimeMillis() - 31536000000L;
        if (this._registry.size() <= 10000 && ((TaskKeyToken)this._registry.firstKey())._timeStamp >= l) {
            return Collections.emptySet();
        }
        HashSet<TaskKeyToken> hashSet = new HashSet<TaskKeyToken>();
        Object object = this._registry.keySet().iterator();
        while (object.hasNext() && (taskKeyToken2 = (TaskKeyToken)object.next())._timeStamp < l) {
            hashSet.add(taskKeyToken2);
        }
        for (TaskKeyToken taskKeyToken2 : hashSet) {
            this.removeTaskInternal(taskKeyToken2);
        }
        while (this._registry.size() > 10000) {
            object = (TaskKeyToken)this._registry.firstKey();
            this.removeTaskInternal((TaskKeyToken)object);
            hashSet.add((TaskKeyToken)object);
        }
        return hashSet;
    }

    @GuardedBy(value="_writeLock")
    private void removeTaskInternal(TaskKeyToken taskKeyToken) {
        this._registry.remove(taskKeyToken);
        String string = this._sessionIdByTaskKey.remove(taskKeyToken);
        if (string == null) {
            return;
        }
        Map<TaskKeyToken, TaskState> map = this._terminalStatesBySessionId.get(string);
        map.remove(taskKeyToken);
        if (map.isEmpty()) {
            this._terminalStatesBySessionId.remove(string);
        }
    }

    @Immutable
    private static class ImmutableTaskInfo {
        private static final Field[] CLIENT_TASK_INFO_FIELDS = ClientTaskInfo.class.getFields();
        private static final int NUMBER_OF_FIELDS = CLIENT_TASK_INFO_FIELDS.length;
        private final Map<String, Object> _fieldValuesByFieldName;

        ImmutableTaskInfo(ClientTaskInfo clientTaskInfo) {
            if (clientTaskInfo == null) {
                throw new IllegalStateException("Null task info not expected here.");
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>(NUMBER_OF_FIELDS);
            for (Field field : CLIENT_TASK_INFO_FIELDS) {
                Object object;
                try {
                    object = field.get(clientTaskInfo);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalStateException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException(illegalAccessException);
                }
                hashMap.put(field.getName(), object);
            }
            this._fieldValuesByFieldName = Collections.unmodifiableMap(hashMap);
        }

        ClientTaskInfo getClientTaskInfo() {
            ClientTaskInfo clientTaskInfo = new ClientTaskInfo();
            for (Field field : CLIENT_TASK_INFO_FIELDS) {
                String string = field.getName();
                Object object = this._fieldValuesByFieldName.get(string);
                try {
                    field.set(clientTaskInfo, object);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new IllegalStateException(illegalArgumentException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IllegalStateException(illegalAccessException);
                }
            }
            return clientTaskInfo;
        }

        Object getFieldValue(String string) {
            if (!this._fieldValuesByFieldName.containsKey(string)) {
                throw new IllegalArgumentException("Non-existent field name");
            }
            Object object = this._fieldValuesByFieldName.get(string);
            return object;
        }
    }

    @Immutable
    private static class TaskKeyToken
    implements Comparable<TaskKeyToken> {
        private final long _timeStamp;
        private final long _sequenceNr;
        private final int _hashCode;

        TaskKeyToken(long l, long l2) {
            this._timeStamp = l;
            this._sequenceNr = l2;
            int n = 17;
            n = 31 * n + Long.valueOf(l).hashCode();
            this._hashCode = n = 31 * n + Long.valueOf(l2).hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof TaskKeyToken)) {
                return false;
            }
            TaskKeyToken taskKeyToken = (TaskKeyToken)object;
            if (taskKeyToken._timeStamp != this._timeStamp) {
                return false;
            }
            if (taskKeyToken._sequenceNr != this._sequenceNr) {
                return false;
            }
            return false;
        }

        public int hashCode() {
            return this._hashCode;
        }

        @Override
        public int compareTo(TaskKeyToken taskKeyToken) {
            if (this._timeStamp < taskKeyToken._timeStamp) {
                return -1;
            }
            if (this._timeStamp > taskKeyToken._timeStamp) {
                return 1;
            }
            if (this._sequenceNr < taskKeyToken._sequenceNr) {
                return -1;
            }
            if (this._sequenceNr > taskKeyToken._sequenceNr) {
                return 1;
            }
            return 0;
        }
    }
}

