/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.impl.EventFilter;
import com.vmware.opsmgmt.client.event.impl.EventProvider;
import com.vmware.opsmgmt.client.event.util.Util;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataProviderAdapter;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.ValidationUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.extensions.LinkedVcGroupRegistry;
import com.vmware.vise.vim.commons.vcservice.LinkedVcGroup;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseEventProcessor
implements DataProviderAdapter {
    private static final Log _logger = LogFactory.getLog(BaseEventProcessor.class);
    protected static final String EVENT_TYPE = Event.class.getSimpleName();

    protected abstract TypeInfo getTypeInfo();

    public BaseEventProcessor(DataServiceExtensionRegistry dataServiceExtensionRegistry) {
        dataServiceExtensionRegistry.registerDataAdapter((DataProviderAdapter)this, this.getProvidedTypes());
    }

    private String[] getProvidedTypes() {
        return new String[]{this.getTypeInfo().type};
    }

    public Response getData(RequestSpec requestSpec) {
        ValidationUtil.paramsNotNull((Object[])new Object[]{requestSpec});
        QuerySpec[] querySpecArray = requestSpec.querySpec;
        ResultSet[] resultSetArray = new ResultSet[querySpecArray.length];
        for (int i = 0; i < querySpecArray.length; ++i) {
            resultSetArray[i] = this.getData(querySpecArray[i]);
        }
        Response response = new Response();
        response.resultSet = resultSetArray;
        return response;
    }

    protected ResultSet getData(QuerySpec querySpec) {
        if (!this.isValidQuery(querySpec)) {
            return null;
        }
        ResultSet resultSet = new ResultSet();
        resultSet.queryName = querySpec.name;
        try {
            ResultItem[] resultItemArray;
            EventFilter eventFilter = new EventFilter(querySpec);
            ResultSet resultSet2 = null;
            EventProvider.ConsolidatedEvents consolidatedEvents = this.processQuery(eventFilter);
            if (!ArrayUtil.isNullOrEmpty((Object[])eventFilter.migrationHistoryList)) {
                int n = 0;
                for (Map.Entry<ManagedObjectReference, List<Event>> object2 : consolidatedEvents.events.entrySet()) {
                    resultItemArray = object2.getValue();
                    n += resultItemArray.size();
                }
                if (eventFilter.count > n) {
                    resultSet2 = this.getMigratedResults(querySpec, eventFilter, eventFilter.count - n);
                }
            }
            ArrayList<MethodFault> arrayList = new ArrayList<MethodFault>();
            List<ResultItem> list = this.processEventsResult(consolidatedEvents.events, arrayList, querySpec);
            Exception exception = this.processErrorResult(consolidatedEvents.errors, arrayList);
            resultItemArray = list.toArray(new ResultItem[list.size()]);
            if (resultSet2 != null && resultSet2.items != null && resultSet2.items.length > 0) {
                ResultItem[] resultItemArray2 = new ResultItem[list.size() + resultSet2.items.length];
                System.arraycopy(resultItemArray, 0, resultItemArray2, 0, resultItemArray.length);
                System.arraycopy(resultSet2.items, 0, resultItemArray2, resultItemArray.length, resultSet2.items.length);
                resultSet.items = resultItemArray2;
            } else {
                resultSet.items = resultItemArray;
            }
            resultSet.totalMatchedObjectCount = resultSet.items.length;
            resultSet.error = exception;
        }
        catch (Exception exception) {
            _logger.error((Object)("Error in getData for querySpec: " + querySpec.name), (Throwable)exception);
            resultSet.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return resultSet;
    }

    private ResultSet getMigratedResults(QuerySpec querySpec, EventFilter eventFilter, int n) {
        ResultSet resultSet = null;
        ManagedObjectReference managedObjectReference = eventFilter.eventFilterSpec.entity.entity;
        if (eventFilter.requestingPrevPage) {
            for (int i = 0; i < eventFilter.migrationHistoryList.length - 1; ++i) {
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)managedObjectReference, (ManagedObjectReference)eventFilter.migrationHistoryList[i]).booleanValue() || i >= eventFilter.migrationHistoryList.length + 1) continue;
                QuerySpec querySpec2 = Util.makeReplacementQuerySpec(querySpec, eventFilter.migrationHistoryList[i + 1], n);
                resultSet = this.getData(querySpec2);
            }
        } else {
            for (int i = eventFilter.migrationHistoryList.length - 1; i >= 1; --i) {
                if (!ManagedObjectUtil.areEqual((ManagedObjectReference)managedObjectReference, (ManagedObjectReference)eventFilter.migrationHistoryList[i]).booleanValue() || i <= 0) continue;
                QuerySpec querySpec3 = Util.makeReplacementQuerySpec(querySpec, eventFilter.migrationHistoryList[i - 1], n);
                resultSet = this.getData(querySpec3);
            }
        }
        return resultSet;
    }

    protected abstract List<ResultItem> processEventsResult(Map<ManagedObjectReference, List<Event>> var1, List<MethodFault> var2, QuerySpec var3);

    private boolean isValidQuery(QuerySpec querySpec) {
        if (querySpec.resourceSpec == null) {
            return false;
        }
        PropertySpec[] propertySpecArray = querySpec.resourceSpec.propertySpecs;
        String[] stringArray = this.getTypeInfo().properties;
        for (int i = 0; i < propertySpecArray.length; ++i) {
            String[] stringArray2 = propertySpecArray[i].propertyNames;
            for (int j = 0; j < stringArray2.length; ++j) {
                for (int k = 0; k < stringArray.length; ++k) {
                    if (!stringArray[k].equals(stringArray2[j])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private EventProvider.ConsolidatedEvents processQuery(EventFilter eventFilter) {
        if (eventFilter.eventFilterSpec.eventChainId != null && eventFilter.eventFilterSpec.eventChainId <= 0) {
            return new EventProvider.ConsolidatedEvents(new HashMap<ManagedObjectReference, List<Event>>(), new HashMap<ManagedObjectReference, Exception>());
        }
        List<VcService> list = this.getServices(eventFilter);
        EventProvider eventProvider = new EventProvider(list, eventFilter);
        return eventProvider.collect();
    }

    private Exception processErrorResult(Map<ManagedObjectReference, Exception> map, List<MethodFault> list) {
        if (map == null || map.isEmpty()) {
            return null;
        }
        ArrayList<MethodFault> arrayList = new ArrayList<MethodFault>(map.size());
        for (Exception exception : map.values()) {
            arrayList.add(MixedUtil.getMethodFault((Throwable)exception));
        }
        if (list != null && list.size() > 0) {
            arrayList.addAll(list);
        }
        return new CompositeException(arrayList);
    }

    private List<VcService> getServices(EventFilter eventFilter) {
        ArrayList<VcService> arrayList = new ArrayList<VcService>();
        if (!StringUtil.isNullOrEmpty((String)eventFilter.serverGuid)) {
            VcService vcService = VimSessionUtil.getService((String)eventFilter.serverGuid);
            if (vcService != null) {
                arrayList.add(vcService);
            }
        } else {
            LinkedVcGroup[] linkedVcGroupArray;
            LinkedVcGroupRegistry linkedVcGroupRegistry = VimSessionUtil.getLinkedVcGroupRegistry();
            for (LinkedVcGroup linkedVcGroup : linkedVcGroupArray = linkedVcGroupRegistry.getLinkedVcGroups()) {
                Collection collection = linkedVcGroup.getVcServices();
                arrayList.addAll(collection);
            }
        }
        return arrayList;
    }
}

