/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.vmware.opsmgmt.client.event.EventDetailDescription;
import com.vmware.opsmgmt.client.event.impl.EntityEventArgumentWrapper;
import com.vmware.opsmgmt.client.event.impl.EventWrapper;
import com.vmware.opsmgmt.client.event.impl.i18n.MessageParser;
import com.vmware.vim.binding.impl.vmodl.TypeNameImpl;
import com.vmware.vim.binding.vim.StoragePod;
import com.vmware.vim.binding.vim.event.Event;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vim.event.TaskEvent;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vise.core.model.OperationResult;
import com.vmware.vise.core.model.event.ClientEventDetailInfo;
import com.vmware.vise.core.model.event.ClientEventEntityInfo;
import com.vmware.vise.core.model.event.ClientEventInfo;
import com.vmware.vise.messaging.amf.DataObjectProxy;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.mixed.ManagedEntityParentLocator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class EventBuilder {
    private ClientEventInfo _clientEvent;
    private final ManagedEntityParentLocator _locator;
    private final Set<ManagedObjectReference> _existingMoRefs;
    private final Set<ManagedObjectReference> _removedMoRefs = new HashSet<ManagedObjectReference>();
    private static final String CATEGORY_FORMAT = "%s.category";
    private static final String DESCRIPTION_FORMAT = "%s.description";
    private static final String COMPUTE_RESOURCE_FORMAT = "%s.formatOnComputeResource";
    private static final String DATACENTER_FORMAT = "%s.formatOnDatacenter";
    private static final String HOST_FORMAT = "%s.formatOnHost";
    private static final String VM_FORMAT = "%s.formatOnVm";
    private static final String FULL_FORMAT = "%s.fullFormat";
    private static final String COMPUTERESOURCE_ENTITY_KEY = "computeResource";
    private static final String DC_ENTITY_KEY = "datacenter";
    private static final String DS_ENTITY_KEY = "ds";
    private static final String DVS_ENTITY_KEY = "dvs";
    private static final String HOST_ENTITY_KEY = "host";
    private static final String NET_ENTITY_KEY = "net";
    private static final String VM_ENTITY_KEY = "vm";
    private static final Set<String> REMOVAL_EVENT_TYPES = new HashSet<String>();
    private Map<ManagedObjectReference, OperationResult> _parentInfos;
    private List<MethodFault> _allFaults;
    private final Map<ManagedObjectReference, ManagedObjectReference> _dvsMap;
    private Set<ManagedObjectReference> _uniqueTargetSet;

    public EventBuilder(ManagedEntityParentLocator managedEntityParentLocator, Map<ManagedObjectReference, OperationResult> map, Map<ManagedObjectReference, ManagedObjectReference> map2, List<MethodFault> list) {
        this._locator = managedEntityParentLocator;
        this._parentInfos = map;
        this._allFaults = list;
        this._dvsMap = map2;
        this._existingMoRefs = new HashSet<ManagedObjectReference>();
        this._uniqueTargetSet = new HashSet<ManagedObjectReference>();
    }

    public ClientEventInfo build(EventWrapper eventWrapper, String string) {
        Object object;
        OperationResult operationResult;
        this._clientEvent = new ClientEventInfo();
        this._clientEvent.serverGuid = string;
        this._clientEvent.serverEvent = eventWrapper.getServerEvent();
        Event event = eventWrapper.getServerEvent();
        this._clientEvent.serverEvent = event;
        this._clientEvent.chainId = event.chainId;
        this._clientEvent.isTaskEvent = event instanceof TaskEvent;
        this._clientEvent.createdTime = event.createdTime.getTime();
        this._clientEvent.userName = event.userName;
        this._clientEvent.fullFormattedMessage = event.fullFormattedMessage;
        this._clientEvent.categoryKey = EventDescription.EventCategory.error.name();
        this._clientEvent.eventType = this.getEventType(event);
        this._clientEvent.key = event.key;
        EventDetailDescription eventDetailDescription = eventWrapper.getEventDescription();
        this._clientEvent.eventDetail = eventDetailDescription != null ? new ClientEventDetailInfo(eventDetailDescription.eventDetail) : new ClientEventDetailInfo();
        this._clientEvent.eventTypeId = eventWrapper.getEventTypeId();
        this._clientEvent.longDescription = eventWrapper.getLongDescription();
        this._clientEvent.targetEntityMor = eventWrapper.getTargetMor();
        if (this._dvsMap.containsKey(this._clientEvent.targetEntityMor)) {
            this._clientEvent.targetEntityMor = this._dvsMap.get(this._clientEvent.targetEntityMor);
        }
        ManagedObjectReference managedObjectReference = (ManagedObjectReference)this._clientEvent.targetEntityMor;
        if (REMOVAL_EVENT_TYPES.contains(this._clientEvent.eventType)) {
            this._removedMoRefs.add(managedObjectReference);
        }
        if ((operationResult = this.postProcessMor(this._parentInfos, managedObjectReference, this._allFaults)) != null) {
            this._clientEvent.targetEntityName = (String)operationResult.result;
            this._clientEvent.targetEntityMor = (ManagedObjectReference)operationResult.entity;
        } else {
            this._clientEvent.targetEntityName = eventWrapper.getTargetMorName();
        }
        if (this._clientEvent.targetEntityMor != null && this._clientEvent.targetEntityMor instanceof ManagedObjectReference) {
            this._uniqueTargetSet.add((ManagedObjectReference)this._clientEvent.targetEntityMor);
        }
        for (EntityEventArgumentWrapper entityEventArgumentWrapper : eventWrapper.getEventArguments()) {
            OperationResult operationResult2;
            ManagedObjectReference managedObjectReference2 = entityEventArgumentWrapper.getMoref();
            if (this._dvsMap.containsKey(managedObjectReference2)) {
                entityEventArgumentWrapper.setMoRef(this._dvsMap.get(managedObjectReference2));
                managedObjectReference2 = entityEventArgumentWrapper.getMoref();
            }
            if ((operationResult2 = this.postProcessMor(this._parentInfos, managedObjectReference2, this._allFaults)) == null) continue;
            entityEventArgumentWrapper.getArguments().name = (String)operationResult2.result;
            entityEventArgumentWrapper.setMoRef((ManagedObjectReference)operationResult2.entity);
        }
        if (this.isStoragePodRelated(event)) {
            object = (EventEx)event;
            object.setObjectName(MixedUtil.unescapeVimEntityNameSpecialChars((String)object.getObjectName()));
        }
        this._clientEvent.existingEntities = this._existingMoRefs.toArray(ManagedObjectUtil.EMPTY_MANAGED_OBJECT_ARR);
        this._clientEvent.associatedEntities = new HashMap();
        if (event.computeResource != null) {
            this._clientEvent.associatedEntities.put(COMPUTERESOURCE_ENTITY_KEY, new ClientEventEntityInfo(event.computeResource));
        }
        if (event.datacenter != null) {
            this._clientEvent.associatedEntities.put(DC_ENTITY_KEY, new ClientEventEntityInfo(event.datacenter));
        }
        if (event.ds != null) {
            this._clientEvent.associatedEntities.put(DS_ENTITY_KEY, new ClientEventEntityInfo(event.ds));
        }
        if (event.dvs != null) {
            this._clientEvent.associatedEntities.put(DVS_ENTITY_KEY, new ClientEventEntityInfo(event.dvs));
        }
        if (event.host != null) {
            this._clientEvent.associatedEntities.put(HOST_ENTITY_KEY, new ClientEventEntityInfo(event.host));
        }
        if (event.net != null) {
            this._clientEvent.associatedEntities.put(NET_ENTITY_KEY, new ClientEventEntityInfo(event.net));
        }
        if (event.vm != null) {
            this._clientEvent.associatedEntities.put(VM_ENTITY_KEY, new ClientEventEntityInfo(event.vm));
        }
        object = new MessageParser(new DataObjectProxy((Object)event), event);
        this.localizeEventDetail(this._clientEvent);
        this._clientEvent.categoryKey = eventWrapper.getCategoryKey();
        this._clientEvent.categoryName = eventWrapper.getCategoryName();
        this.formatArguments((MessageParser)object, this._clientEvent);
        if (!StringUtil.isNullOrEmpty((String)this._clientEvent.targetEntityName)) {
            this._clientEvent.targetEntityName = ((MessageParser)object).fixupFTName(this._clientEvent.targetEntityName);
        }
        return this._clientEvent;
    }

    public Set<ManagedObjectReference> getUniqueTargets() {
        return this._uniqueTargetSet;
    }

    public Set<ManagedObjectReference> getRemovedEntities() {
        return this._removedMoRefs;
    }

    private String getEventType(Event event) {
        String string = null;
        string = event instanceof ExtendedEvent ? ((ExtendedEvent)event).eventTypeId : (event instanceof EventEx ? ((EventEx)event).eventTypeId : event.getClass().getSimpleName());
        return string;
    }

    private OperationResult postProcessMor(Map<ManagedObjectReference, OperationResult> map, ManagedObjectReference managedObjectReference, List<MethodFault> list) {
        this._existingMoRefs.add(managedObjectReference);
        OperationResult operationResult = null;
        boolean bl = false;
        OperationResult operationResult2 = map.get(managedObjectReference);
        if (operationResult2 != null) {
            if (operationResult2.error != null) {
                list.add((MethodFault)operationResult2.error);
                return operationResult;
            }
            boolean bl2 = this._locator.customParentRelated(managedObjectReference, (ManagedObjectReference)operationResult2.entity);
            if (bl2) {
                operationResult = operationResult2;
                this._existingMoRefs.remove(managedObjectReference);
                if (map.containsKey(operationResult2.entity)) {
                    this._existingMoRefs.add((ManagedObjectReference)operationResult2.entity);
                }
                bl = true;
            }
        }
        if (!bl && ManagedObjectUtil.isRootFolder((ManagedObjectReference)managedObjectReference)) {
            operationResult = new OperationResult();
            operationResult.result = VcServiceUtil.getServiceName((String)this._clientEvent.serverGuid);
            operationResult.entity = managedObjectReference;
        }
        if (operationResult != null) {
            operationResult.result = MixedUtil.unescapeVimEntityNameSpecialChars((String)((String)operationResult.result));
        }
        return operationResult;
    }

    private void formatArguments(MessageParser messageParser, ClientEventInfo clientEventInfo) {
        ClientEventDetailInfo clientEventDetailInfo = clientEventInfo.eventDetail;
        ClientEventDetailInfo clientEventDetailInfo2 = new ClientEventDetailInfo();
        clientEventDetailInfo2.category = clientEventDetailInfo.category;
        messageParser.parse(clientEventDetailInfo.description);
        clientEventDetailInfo2.description = messageParser.getFullFormattedMessage();
        messageParser.parse(clientEventDetailInfo.formatOnComputeResource);
        clientEventDetailInfo2.formatOnComputeResource = messageParser.getFullFormattedMessage();
        messageParser.parse(clientEventDetailInfo.formatOnDatacenter);
        clientEventDetailInfo2.formatOnDatacenter = messageParser.getFullFormattedMessage();
        messageParser.parse(clientEventDetailInfo.formatOnHost);
        clientEventDetailInfo2.formatOnHost = messageParser.getFullFormattedMessage();
        messageParser.parse(clientEventDetailInfo.formatOnVm);
        clientEventDetailInfo2.formatOnVm = messageParser.getFullFormattedMessage();
        messageParser.parse(clientEventDetailInfo.fullFormat);
        clientEventDetailInfo2.fullFormat = messageParser.getFullFormattedMessage();
        clientEventInfo.linkableFormattedMessage = messageParser.getLinkableFormattedMessage();
        clientEventDetailInfo2.key = clientEventDetailInfo.key;
        clientEventDetailInfo2.longDescription = clientEventDetailInfo.longDescription;
        clientEventInfo.eventDetail = clientEventDetailInfo2;
    }

    private void localizeEventDetail(ClientEventInfo clientEventInfo) {
        String string = clientEventInfo.eventType;
        if (string != null) {
            String string2;
            ClientEventDetailInfo clientEventDetailInfo = clientEventInfo.eventDetail;
            clientEventDetailInfo.category = this.getMessage(CATEGORY_FORMAT, clientEventDetailInfo.category, string);
            String string3 = clientEventDetailInfo.description != null ? clientEventDetailInfo.description : string;
            clientEventDetailInfo.description = this.getMessage(DESCRIPTION_FORMAT, string3, string);
            string3 = clientEventDetailInfo.fullFormat != null ? clientEventDetailInfo.fullFormat : string;
            clientEventDetailInfo.fullFormat = string2 = this.getMessage(FULL_FORMAT, string3, string);
            string3 = clientEventDetailInfo.formatOnComputeResource != null ? clientEventDetailInfo.formatOnComputeResource : string2;
            clientEventDetailInfo.formatOnComputeResource = this.getMessage(COMPUTE_RESOURCE_FORMAT, string3, string);
            string3 = clientEventDetailInfo.formatOnDatacenter != null ? clientEventDetailInfo.formatOnDatacenter : string2;
            clientEventDetailInfo.formatOnDatacenter = this.getMessage(DATACENTER_FORMAT, string3, string);
            string3 = clientEventDetailInfo.formatOnHost != null ? clientEventDetailInfo.formatOnHost : string2;
            clientEventDetailInfo.formatOnHost = this.getMessage(HOST_FORMAT, string3, string);
            string3 = clientEventDetailInfo.formatOnVm != null ? clientEventDetailInfo.formatOnVm : string2;
            clientEventDetailInfo.formatOnVm = this.getMessage(VM_FORMAT, string3, string);
            if (clientEventDetailInfo.key == null) {
                clientEventDetailInfo.key = new TypeNameImpl(string).toString();
            }
        }
    }

    private String getArgumentByKey(String string) {
        if (this._clientEvent == null || !(this._clientEvent.serverEvent instanceof EventEx)) {
            return null;
        }
        EventEx eventEx = (EventEx)this._clientEvent.serverEvent;
        if (eventEx.arguments != null) {
            for (KeyAnyValue keyAnyValue : eventEx.arguments) {
                if (!keyAnyValue.getKey().equals(string)) continue;
                return (String)keyAnyValue.getValue();
            }
        }
        return null;
    }

    private String getMessage(String string, String string2, String string3) {
        String string4 = String.format(string, string3);
        String string5 = string2 == null ? string4 : string2;
        String string6 = LocalizationUtil.getLocalizedMessage((String)string4, null);
        if ((StringUtil.isNullOrEmpty((String)string6) || string6.equals(string4)) && (StringUtil.isNullOrEmpty((String)(string6 = this.getArgumentByKey(string4))) || string6.equals(string4))) {
            string6 = string5;
        }
        return string6;
    }

    private boolean isStoragePodRelated(Event event) {
        boolean bl = false;
        if (event instanceof EventEx) {
            String string;
            EventEx eventEx = (EventEx)event;
            String string2 = StoragePod.class.getAnnotation(wsdlName.class).value();
            if (eventEx.objectType != null && string2.equals(string = ((TypeNameImpl)eventEx.objectType).getWsdlName())) {
                bl = true;
            }
        }
        return bl;
    }

    static {
        REMOVAL_EVENT_TYPES.add("VmRemovedEvent");
        REMOVAL_EVENT_TYPES.add("HostRemovedEvent");
    }
}

