/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.opsmgmt.client.event.impl;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.vmware.opsmgmt.client.commons.util.ManagedObjectTypes;
import com.vmware.opsmgmt.client.event.EventDetailDescription;
import com.vmware.opsmgmt.client.event.impl.EventDetailDescriptionStore;
import com.vmware.vim.binding.vim.ElementDescription;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.event.EventDescription;
import com.vmware.vim.binding.vim.event.EventEx;
import com.vmware.vim.binding.vim.event.EventManager;
import com.vmware.vim.binding.vim.event.ExtendedEvent;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.QueryUtil;
import com.vmware.vise.data.query.RequestSpec;
import com.vmware.vise.data.query.Response;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.util.ArrayUtil;
import com.vmware.vise.util.StringUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EventDescriptionCollector {
    private static final Log _logger = LogFactory.getLog(EventDescriptionCollector.class);
    private static final CacheLoader<Context, EventDescriptionCollector> COLLECTOR_LOADER = new CacheLoader<Context, EventDescriptionCollector>(){

        public EventDescriptionCollector load(Context context) throws Exception {
            if (_logger.isInfoEnabled()) {
                _logger.info((Object)("No event description data found for VC with GUID " + context._serverGuid + " and locale " + context._localeId + ". Load it from the server and store it in memory."));
            }
            EventManager eventManager = EventDescriptionCollector.getEventManagerInstance(context._serverGuid);
            EventDescriptionCollector eventDescriptionCollector = new EventDescriptionCollector(eventManager, context._dataService);
            return eventDescriptionCollector;
        }
    };
    private static final LoadingCache<Context, EventDescriptionCollector> COLLECTORS_BY_LOCALE_AND_VC = CacheBuilder.newBuilder().softValues().build(COLLECTOR_LOADER);
    private final Map<String, ElementDescription> _categoryDescriptions;
    private EventDetailDescriptionStore _store;

    static EventDescriptionCollector getEventDetailDescriptionCollector(String string, DataService dataService) throws Exception {
        String string2 = ResourceUtil.getLocale().toString();
        Context context = new Context(string2, string, dataService);
        Object object = SessionUtil.setDataIfAbsent((String)context.toString(), (Object)Boolean.TRUE);
        if (object == null) {
            COLLECTORS_BY_LOCALE_AND_VC.refresh((Object)context);
        }
        EventDescriptionCollector eventDescriptionCollector = (EventDescriptionCollector)COLLECTORS_BY_LOCALE_AND_VC.get((Object)context);
        return eventDescriptionCollector;
    }

    private EventDescriptionCollector(EventManager eventManager, DataService dataService) {
        if (eventManager == null) {
            throw new IllegalArgumentException("Not initialized EventManager instance.");
        }
        this._categoryDescriptions = new HashMap<String, ElementDescription>();
        this.buildStore(eventManager, dataService);
    }

    private void buildStore(EventManager eventManager, DataService dataService) {
        EventDescription eventDescription = this.loadEventDetails(eventManager);
        this.extractCategoryDescriptions(eventDescription);
        this._store = this.createStore(dataService, eventDescription);
    }

    EventDetailDescription[] collectDetails(String[] stringArray, String string) throws Exception {
        EventDetailDescription[] eventDetailDescriptionArray = this._store.getByIds(stringArray);
        EventDescriptionCollector.addArgumentData(eventDetailDescriptionArray, EventDescriptionCollector.getEventManagerInstance(string));
        return eventDetailDescriptionArray;
    }

    EventDetailDescription[] collectDetails(String[] stringArray) {
        EventDetailDescription[] eventDetailDescriptionArray = this._store.getByIds(stringArray);
        return eventDetailDescriptionArray;
    }

    EventDetailDescription[] collectDetails(ManagedObjectTypes managedObjectTypes, String string) throws Exception {
        EventDetailDescription[] eventDetailDescriptionArray = this._store.getByType(managedObjectTypes);
        EventDescriptionCollector.addArgumentData(eventDetailDescriptionArray, EventDescriptionCollector.getEventManagerInstance(string));
        return eventDetailDescriptionArray;
    }

    EventDetailDescription[] collectDetails(ManagedObjectTypes managedObjectTypes) {
        EventDetailDescription[] eventDetailDescriptionArray = this._store.getByType(managedObjectTypes);
        return eventDetailDescriptionArray;
    }

    private static void addArgumentData(EventDetailDescription[] eventDetailDescriptionArray, EventManager eventManager) {
        if (eventDetailDescriptionArray != null && eventDetailDescriptionArray.length > 1) {
            for (EventDetailDescription eventDetailDescription : eventDetailDescriptionArray) {
                if (eventDetailDescription.eventArguments != null) continue;
                eventDetailDescription.eventArguments = eventManager.retrieveArgumentDescription(eventDetailDescription.eventTypeId);
            }
        }
    }

    private void extractCategoryDescriptions(EventDescription eventDescription) {
        ElementDescription[] elementDescriptionArray = eventDescription.getCategory();
        if (elementDescriptionArray == null || elementDescriptionArray.length == 0) {
            return;
        }
        for (ElementDescription elementDescription : elementDescriptionArray) {
            this._categoryDescriptions.put(elementDescription.label, elementDescription);
        }
    }

    private EventDescription loadEventDetails(EventManager eventManager) {
        EventDescription eventDescription = eventManager.getDescription();
        EventDescription.EventDetail[] eventDetailArray = eventDescription.getEventInfo();
        if (eventDetailArray == null || eventDetailArray.length == 0) {
            throw new RuntimeException("No details are found in server: " + eventManager._getRef().getServerGuid());
        }
        return eventDescription;
    }

    private EventDetailDescriptionStore createStore(DataService dataService, EventDescription eventDescription) {
        EventDetailDescriptionStore eventDetailDescriptionStore = new EventDetailDescriptionStore();
        Map<String, Set<String>> map = this.getEventClassification(dataService);
        for (EventDescription.EventDetail eventDetail : eventDescription.getEventInfo()) {
            if (eventDetail.key == null) continue;
            EventDetailDescription eventDetailDescription = this.extractDetails(eventDetail);
            Set<String> set = map.get(eventDetailDescription.eventTypeId);
            if (set != null && set.size() != 0) {
                for (String string : set) {
                    ManagedObjectTypes managedObjectTypes;
                    try {
                        managedObjectTypes = ManagedObjectTypes.getValueOf((String)string);
                    }
                    catch (Exception exception) {
                        _logger.warn((Object)("No enum value for " + string));
                        managedObjectTypes = ManagedObjectTypes.MANAGED_ENTITY;
                    }
                    eventDetailDescriptionStore.putDescription(managedObjectTypes, eventDetailDescription);
                }
                continue;
            }
            eventDetailDescriptionStore.putDescription(ManagedObjectTypes.MANAGED_ENTITY, eventDetailDescription);
        }
        return eventDetailDescriptionStore;
    }

    private EventDetailDescription extractDetails(EventDescription.EventDetail eventDetail) {
        EventDetailDescription eventDetailDescription = new EventDetailDescription();
        eventDetailDescription.eventTypeId = this.getEventTypeId(eventDetail);
        eventDetailDescription.eventDescription = !StringUtil.isNullOrEmpty((String)eventDetail.description) ? eventDetail.description : (!StringUtil.isNullOrEmpty((String)eventDetailDescription.eventTypeId) ? eventDetailDescription.eventTypeId : eventDetail.key.getName());
        eventDetailDescription.eventDetail = eventDetail;
        eventDetailDescription.categoryDescription = this._categoryDescriptions.get(eventDetail.category);
        return eventDetailDescription;
    }

    private String getEventTypeId(EventDescription.EventDetail eventDetail) {
        String string = null;
        String string2 = eventDetail.getKey().getName();
        if (ExtendedEvent.class.getName().equals(string2) || EventEx.class.getName().equals(string2)) {
            if (!StringUtil.isNullOrEmpty((String)eventDetail.fullFormat)) {
                int n = eventDetail.fullFormat.indexOf("|");
                string = n != -1 ? eventDetail.fullFormat.substring(0, n) : eventDetail.fullFormat;
            }
        } else {
            string = string2;
        }
        return string;
    }

    private Map<String, Set<String>> getEventClassification(DataService dataService) {
        Constraint constraint = new Constraint();
        constraint.targetType = "EventClassification";
        QuerySpec querySpec = QueryUtil.buildQuerySpec((Constraint)constraint, (String[])new String[]{"allEvents"});
        RequestSpec requestSpec = new RequestSpec();
        requestSpec.querySpec = new QuerySpec[]{querySpec};
        Response response = dataService.getData(requestSpec);
        Map<String, Set<String>> map = this.processEventClassificationResults(response.resultSet);
        if (map == null) {
            map = new HashMap<String, Set<String>>();
        }
        return map;
    }

    private Map<String, Set<String>> processEventClassificationResults(ResultSet[] resultSetArray) {
        if (ArrayUtil.isNullOrEmpty((Object[])resultSetArray)) {
            _logger.error((Object)"Empty result for EventClassification.allEvents");
            return null;
        }
        Map map = null;
        for (ResultSet resultSet : resultSetArray) {
            if (ArrayUtil.isNullOrEmpty((Object[])resultSet.items)) {
                _logger.warn((Object)"Empty ResultSet.items");
                continue;
            }
            for (ResultItem resultItem : resultSet.items) {
                Object[] objectArray = resultItem.properties;
                if (ArrayUtil.isNullOrEmpty((Object[])objectArray)) continue;
                for (Object object : objectArray) {
                    Map map2 = (Map)((PropertyValue)object).value;
                    if (map != null) {
                        this.combineMaps(map2, map);
                        continue;
                    }
                    map = map2;
                }
            }
        }
        return map;
    }

    private void combineMaps(Map<String, Set<String>> map, Map<String, Set<String>> map2) {
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            Set<String> set = map2.get(entry.getKey());
            if (set == null) {
                set = new HashSet<String>();
                map2.put(entry.getKey(), set);
            }
            set.addAll((Collection<String>)entry.getValue());
        }
    }

    private static EventManager getEventManagerInstance(String string) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)string);
        ServiceInstanceContent serviceInstanceContent = vcService.getServiceInstanceContent();
        return (EventManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceInstanceContent.eventManager);
    }

    private static class Context {
        private final String _localeId;
        private final String _serverGuid;
        private transient DataService _dataService;

        Context(String string, String string2, DataService dataService) {
            this._localeId = string;
            this._serverGuid = string2;
            this._dataService = dataService;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Context)) {
                return false;
            }
            Context context = (Context)object;
            return this._localeId.equals(context._localeId) && this._serverGuid.equals(context._serverGuid);
        }

        public int hashCode() {
            return Objects.hash(this._localeId, this._serverGuid);
        }

        public String toString() {
            return "Event description context for " + this._localeId + "@" + this._serverGuid;
        }
    }
}

