/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vise.reporting.service;

import com.vmware.vise.reporting.service.BaseDownloadServlet;
import com.vmware.vise.reporting.service.DownloadService;
import com.vmware.vise.reporting.service.data.Downloadable;
import com.vmware.vise.reporting.service.data.DownloadableObjectMap;
import com.vmware.vise.reporting.util.Logger;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.bouncycastle.util.encoders.Base64;

public final class DownloadServlet
extends BaseDownloadServlet
implements DownloadService {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = Logger.getLog(DownloadServlet.class);
    private static final String BASE_PATH = "/reporting-service/";
    private static final long REPORT_CLEANUP_INTERVAL_IN_SECONDS = 86400L;
    private static final int REPORT_CLEANUP_THREAD_POOL_SIZE = 1;
    private static final DownloadableObjectMap DOWNLOADABLE_OBJ_BY_URL = new DownloadableObjectMap();
    private static boolean _isHttpsRequired = false;
    private static String _contextUrl;

    public DownloadServlet() {
        LOG.debug((Object)(this.getClass().getName() + "instantiated."));
    }

    @Override
    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (_isHttpsRequired && !httpServletRequest.isSecure()) {
            httpServletResponse.sendError(403);
            return;
        }
        assert (_contextUrl.equals(httpServletRequest.getContextPath() + BASE_PATH)) : "Configuration error: the effective URL base doesn't match the servlet context";
        super.doGet(httpServletRequest, httpServletResponse);
    }

    public void init() throws ServletException {
        _contextUrl = super.getServletContext().getContextPath() + BASE_PATH;
    }

    @Override
    public boolean hasEntry(String string) {
        boolean bl = DOWNLOADABLE_OBJ_BY_URL.containsKey(string);
        return bl;
    }

    @Override
    public String extractKeyFromUrl(String string) {
        String string2 = string.substring(_contextUrl.length(), string.length()).replaceAll("%20", " ");
        return string2;
    }

    @Override
    public String getMimeType(String string) {
        String string2 = DOWNLOADABLE_OBJ_BY_URL.get(string).getMimeType();
        return string2;
    }

    @Override
    protected byte[] getPayload(String string) {
        byte[] byArray = DOWNLOADABLE_OBJ_BY_URL.get(string).getPayload();
        return byArray;
    }

    @Override
    public String createUrl(Downloadable downloadable) {
        String string = UUID.randomUUID().toString();
        string = new String(Base64.encode((byte[])string.getBytes()));
        String string2 = downloadable.getName();
        if (string2 != null && !string2.equals("")) {
            string = string + "/" + string2;
        }
        DOWNLOADABLE_OBJ_BY_URL.putIfAbsent(string, downloadable);
        return _contextUrl + string;
    }

    @Override
    public Downloadable getDownlodable(String string) {
        String string2 = this.extractKeyFromUrl(string);
        Downloadable downloadable = DOWNLOADABLE_OBJ_BY_URL.get(string2);
        return downloadable;
    }

    @Override
    public boolean deleteDownloadable(String string) {
        String string2 = this.extractKeyFromUrl(string);
        Downloadable downloadable = DOWNLOADABLE_OBJ_BY_URL.remove(string2);
        return downloadable != null;
    }

    public static class CleanupManager
    implements ServletContextListener {
        private final AtomicReference<ScheduledThreadPoolExecutor> _executor = new AtomicReference();

        public void contextInitialized(ServletContextEvent servletContextEvent) {
            WorkerThreadFactory workerThreadFactory = new WorkerThreadFactory("DownloadServlet");
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(1, (ThreadFactory)workerThreadFactory);
            this._executor.set(scheduledThreadPoolExecutor);
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        DOWNLOADABLE_OBJ_BY_URL.removeExpiredDownloadables(86400L);
                    }
                    catch (Exception exception) {
                        LOG.error((Object)"Report cleanup job failed.", (Throwable)exception);
                    }
                }
            };
            scheduledThreadPoolExecutor.scheduleWithFixedDelay(runnable, 86400L, 86400L, TimeUnit.SECONDS);
        }

        public void contextDestroyed(ServletContextEvent servletContextEvent) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = this._executor.get();
            scheduledThreadPoolExecutor.shutdownNow();
        }
    }
}

