/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.virgo.util.parser.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.eclipse.virgo.util.parser.launcher.BundleEntry;
import org.eclipse.virgo.util.parser.launcher.LaunchCommand;
import org.eclipse.virgo.util.parser.launcher.ParseException;

public final class ArgumentParser {
    private static final int MAXIMUM_BUNDLE_DECLARATION_COMPONENTS = 2;
    private static final int MAX_PROPERTY_DECLARATION_COMPONENTS = 2;
    private static final String MARKER_PROPERTY = "-F";
    private static final String MARKER_BUNDLE = "-B";
    private static final String MARKER_CONFIG = "-config";
    private static final String PROPERTY_DELIMITER = "=";
    private static final String BUNDLE_PATH_DELIMITER = "@";
    private static final String START_FLAG = "start";
    protected static final String IVY_CACHE_RELATIVE = String.valueOf(File.separator) + "virgo-build-cache" + File.separator + "ivy-cache";

    public LaunchCommand parse(String[] args) {
        LaunchCommand command = new LaunchCommand();
        int x = 0;
        while (x < args.length) {
            String arg = args[x];
            if (arg.startsWith(MARKER_BUNDLE)) {
                BundleEntry entry = this.parseBundleMarker(arg);
                command.declareBundle(entry.getURI(), entry.isAutoStart());
                ++x;
                continue;
            }
            if (arg.startsWith(MARKER_PROPERTY)) {
                this.parseFrameworkProperty(arg, command);
                ++x;
                continue;
            }
            if (MARKER_CONFIG.equals(arg.trim())) {
                if (++x == args.length) {
                    throw new ParseException("Option -config supplied without path.");
                }
                String configPath = args[x];
                this.parseConfigProperties(configPath, command);
                ++x;
                continue;
            }
            command.declareUnrecognizedArgument(arg);
            ++x;
        }
        return command;
    }

    public BundleEntry[] parseBundleEntries(String entryList) {
        String[] entries = entryList.split(",");
        BundleEntry[] result = new BundleEntry[entries.length];
        int x = 0;
        while (x < result.length) {
            result[x] = this.parseBundleEntry(entries[x]);
            ++x;
        }
        return result;
    }

    public BundleEntry parseBundleEntry(String decl) {
        String[] components = this.parseCommandComponents(decl, BUNDLE_PATH_DELIMITER, 2);
        String path = components[0];
        path = this.processIvyCachePlaceholder(path);
        URI uri = this.pathToURI(path);
        boolean autoStart = false;
        if (components.length == 2) {
            String bundleCommand = components[1];
            if (START_FLAG.equals(bundleCommand)) {
                autoStart = true;
            } else {
                throw new ParseException("Unrecognized bundle command '" + bundleCommand + "' in '" + decl + "'.");
            }
        }
        return new BundleEntry(uri, autoStart);
    }

    private String processIvyCachePlaceholder(String path) {
        return path.replace("${ivy.cache}", String.valueOf(System.getProperty("user.home")) + IVY_CACHE_RELATIVE);
    }

    private void parseConfigProperties(String configPath, LaunchCommand command) {
        File file = new File(configPath);
        if (!file.exists()) {
            throw new ParseException("Config path '" + file.getAbsolutePath() + "' does not exist.");
        }
        Properties props = new Properties();
        FileInputStream stream = null;
        try {
            try {
                stream = new FileInputStream(file);
                props.load(stream);
            }
            catch (IOException e) {
                throw new ParseException("Unable to read config properties file '" + file.getAbsolutePath() + "'.", e);
            }
        }
        catch (Throwable throwable) {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        command.setConfigProperties(props);
    }

    private void parseFrameworkProperty(String arg, LaunchCommand command) {
        String decl = arg.substring(MARKER_PROPERTY.length());
        String[] components = this.parseCommandComponents(decl, PROPERTY_DELIMITER, 2);
        String value = components.length == 2 ? components[1] : "";
        command.declareProperty(components[0], value);
    }

    private BundleEntry parseBundleMarker(String arg) {
        String decl = arg.substring(MARKER_BUNDLE.length());
        return this.parseBundleEntry(decl);
    }

    private String[] parseCommandComponents(String decl, String delimiter, int maxComponents) {
        String[] components = decl.split(delimiter);
        if (components.length > maxComponents) {
            throw new ParseException("Invalid declaration: '" + decl + "'. Too many occurrences of '" + delimiter + "'.");
        }
        return components;
    }

    private URI pathToURI(String path) {
        URI uri = null;
        File f = new File(path);
        if (f.exists()) {
            uri = f.getAbsoluteFile().toURI();
        }
        if (uri == null) {
            path = this.replaceBackslashWithSlash(path);
            path = this.replaceSpaces(path);
            try {
                URI u = new URI(path);
                if (u.isAbsolute()) {
                    uri = u;
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        if (uri == null) {
            throw new ParseException("Path '" + path + "' is not a valid URI or file path");
        }
        return uri;
    }

    private String replaceBackslashWithSlash(String path) {
        return path.replace('\\', '/');
    }

    private String replaceSpaces(String path) {
        return path.replace(" ", "%20");
    }
}

