/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.af;

import com.vmware.af.DomainInfo;
import com.vmware.af.PasswordCredential;
import com.vmware.af.interop.VmAfClientAdapter;

public class VmAfClient {
    private String _vmAfServerUrl;
    private Object _vmAfHeartbeatHandle;

    public VmAfClient(String vmAfServerUrl) {
        assert (vmAfServerUrl != null && !vmAfServerUrl.isEmpty());
        this._vmAfServerUrl = vmAfServerUrl;
    }

    public int getStatus() {
        return VmAfClientAdapter.getStatus(this._vmAfServerUrl);
    }

    public String getDomainName() {
        return VmAfClientAdapter.getDomainName(this._vmAfServerUrl);
    }

    public void setDomainName(String domain) {
        VmAfClientAdapter.setDomainName(this._vmAfServerUrl, domain);
    }

    public int getRHTTPProxyPort() {
        return VmAfClientAdapter.getRHTTPProxyPort(this._vmAfServerUrl);
    }

    public void setRHTTPProxyPort(int port) {
        VmAfClientAdapter.setRHTTPProxyPort(this._vmAfServerUrl, port);
    }

    public void setDCPort(int port) {
        VmAfClientAdapter.setDCPort(this._vmAfServerUrl, port);
    }

    public String getCMLocation() {
        return VmAfClientAdapter.getCMLocation(this._vmAfServerUrl);
    }

    public String getLSLocation() {
        return VmAfClientAdapter.getLSLocation(this._vmAfServerUrl);
    }

    public String getPNID() {
        return VmAfClientAdapter.getPNID(this._vmAfServerUrl);
    }

    public String getPNIDUrl() {
        return VmAfClientAdapter.getPNIDUrl(this._vmAfServerUrl);
    }

    public String getDomainController() {
        return VmAfClientAdapter.getDCName(this._vmAfServerUrl);
    }

    public void setDomainController(String dc) {
        VmAfClientAdapter.setDCName(this._vmAfServerUrl, dc);
    }

    public String getLDU() {
        return VmAfClientAdapter.getLDU(this._vmAfServerUrl);
    }

    public void setLDU(String ldu) {
        VmAfClientAdapter.setLDU(this._vmAfServerUrl, ldu);
    }

    public void promoteVmDir(String server, String domain, String user, String password, String site, String partner) {
        VmAfClientAdapter.promoteVmDir(server, domain, user, password, site, partner);
    }

    public void demoteVmDir(String server, String user, String password) {
        VmAfClientAdapter.demoteVmDir(server, user, password);
    }

    public void joinVmDir(String server, String user, String password, String machine, String domain, String orgunit) {
        VmAfClientAdapter.joinVmDir(server, user, password, machine, domain, orgunit);
    }

    public void leaveVmDir(String server, String user, String password) {
        VmAfClientAdapter.leaveVmDir(server, user, password);
    }

    public void joinActiveDirectory(String server, String user, String password, String domain, String orgunit) {
        VmAfClientAdapter.joinAD(server, user, password, domain, orgunit);
    }

    public void leaveActiveDirectory(String server, String user, String password) {
        VmAfClientAdapter.leaveAD(server, user, password);
    }

    public DomainInfo queryActiveDirectory(String server) {
        return VmAfClientAdapter.queryAD(server);
    }

    public PasswordCredential getMachineAccountCredentials() {
        return VmAfClientAdapter.getMachineAccountCredentials();
    }

    public String getSiteGUID() {
        return VmAfClientAdapter.getSiteGUID(this._vmAfServerUrl);
    }

    public String getMachineID() {
        return VmAfClientAdapter.getMachineID(this._vmAfServerUrl);
    }

    public void startHeartbeat(String ServiceName, int Port) {
        Object pHeartbeatHandle;
        this._vmAfHeartbeatHandle = pHeartbeatHandle = VmAfClientAdapter.startHeartbeat(ServiceName, Port);
    }

    public void stopHeartbeat() {
        if (this._vmAfHeartbeatHandle != null) {
            VmAfClientAdapter.stopHeartbeat(this._vmAfHeartbeatHandle);
            this._vmAfHeartbeatHandle = null;
        }
    }
}

