/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.soap.impl;

import com.vmware.vim.vmomi.core.exception.MarshallException;
import com.vmware.vim.vmomi.core.soap.XmlOutputHandler;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DomXmlOutputHandler
implements XmlOutputHandler {
    private Document _doc;
    private Node _node;
    private Stack<Node> _stack = new Stack();

    public DomXmlOutputHandler() throws MarshallException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbf.newDocumentBuilder();
            this._doc = dBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new MarshallException("Unable to create DOM document", e);
        }
    }

    public Document getDomOutput() {
        return this._doc;
    }

    @Override
    public void writeStartDocument() {
    }

    @Override
    public void writeEndDocument() {
    }

    @Override
    public void writeStartElement(String localName) throws MarshallException {
        try {
            this.appendChild(this._doc.createElement(localName));
        }
        catch (DOMException e) {
            throw new MarshallException(String.format("Unable to create element %1$s", localName), e);
        }
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws MarshallException {
        try {
            this.appendChild(this._doc.createElementNS(namespaceURI, localName));
        }
        catch (DOMException e) {
            throw new MarshallException(String.format("Unable to create element %1$s:%2$s", namespaceURI, localName), e);
        }
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws MarshallException {
        try {
            if (prefix == null || prefix.equals("")) {
                this.writeStartElement(namespaceURI, localName);
            } else {
                this.appendChild(this._doc.createElementNS(namespaceURI, prefix + ":" + localName));
            }
        }
        catch (DOMException e) {
            throw new MarshallException(String.format("Unable to create element %1$s:%2$s", prefix, localName), e);
        }
    }

    @Override
    public void writeCharacters(String text) throws MarshallException {
        try {
            this._node.appendChild(this._doc.createTextNode(text));
        }
        catch (DOMException e) {
            throw new MarshallException(String.format("Unable to append text element %1$s", text), e);
        }
    }

    @Override
    public void writeEndElement() {
        this._node = this._stack.size() > 0 ? this._stack.pop() : null;
    }

    @Override
    public void writeAttribute(String localName, String value) throws MarshallException {
        try {
            Attr attr = null;
            attr = localName.startsWith("xmlns") && (localName.length() == 5 || localName.charAt(5) == ':') ? this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", localName) : this._doc.createAttributeNS(null, localName);
            attr.setValue(value);
            ((Element)this._node).setAttributeNode(attr);
        }
        catch (DOMException e) {
            throw new MarshallException(String.format("Unable to write attribute %1$s", localName), e);
        }
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws MarshallException {
        try {
            Attr attr = this._doc.createAttributeNS(namespaceURI, localName);
            attr.setPrefix(prefix);
            attr.setValue(value);
            ((Element)this._node).setAttributeNodeNS(attr);
        }
        catch (DOMException e) {
            throw new MarshallException(String.format("Unable to write attribute %1$s:%2$s", prefix, localName), e);
        }
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws MarshallException {
        try {
            Attr attr = this._doc.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix);
            attr.setValue(namespaceURI);
            ((Element)this._node).setAttributeNodeNS(attr);
        }
        catch (DOMException e) {
            throw new MarshallException(String.format("Unable to write prefix %1$s for namespace %2$s", prefix, namespaceURI), e);
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws MarshallException {
    }

    protected void appendChild(Element element) {
        if (this._node != null) {
            this._stack.push(this._node);
            this._node.appendChild(element);
        } else {
            this._doc.appendChild(element);
        }
        this._node = element;
    }
}

