/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.types.impl;

import com.vmware.vim.binding.vmodl.link;
import com.vmware.vim.binding.vmodl.linkType;
import com.vmware.vim.binding.vmodl.linkable;
import com.vmware.vim.binding.vmodl.managedObjectType;
import com.vmware.vim.binding.vmodl.optional;
import com.vmware.vim.binding.vmodl.privilege;
import com.vmware.vim.binding.vmodl.secret;
import com.vmware.vim.binding.vmodl.versionClass;
import com.vmware.vim.binding.vmodl.wsdlName;
import com.vmware.vim.vmomi.core.exception.InternalException;
import com.vmware.vim.vmomi.core.types.ComplexTypeField;
import com.vmware.vim.vmomi.core.types.Util;
import com.vmware.vim.vmomi.core.types.VmodlContext;
import com.vmware.vim.vmomi.core.types.VmodlType;
import com.vmware.vim.vmomi.core.types.impl.VmodlFieldImpl;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;

public class ComplexTypeFieldImpl
extends VmodlFieldImpl
implements ComplexTypeField {
    private Method _getter;
    private Method _setter;

    public ComplexTypeFieldImpl(String propertyName, Method getter, Method setter, VmodlContext context) {
        super(context);
        this.init(propertyName, getter, setter);
    }

    private void init(String propertyName, Method getter, Method setter) {
        versionClass versionAnnotation;
        this._getter = getter;
        this._setter = setter;
        this.setName(propertyName);
        wsdlName wsdlNameAnnotation = getter.getAnnotation(wsdlName.class);
        if (wsdlNameAnnotation != null) {
            this.setWsdlName(wsdlNameAnnotation.value());
        }
        this.setOptional(this._getter.getAnnotation(optional.class) != null);
        managedObjectType moTypeAnnotation = this._getter.getAnnotation(managedObjectType.class);
        if (moTypeAnnotation != null) {
            this.setManagedObjectClassName(moTypeAnnotation.value());
        }
        if ((versionAnnotation = this._getter.getAnnotation(versionClass.class)) == null) {
            throw new IllegalArgumentException(String.format("Unsupported @versionClass for method %1$s", this._getter.getName()));
        }
        this.setVersion(this.getVmodlContext().getVmodlVersionMap().getVersion(versionAnnotation.value()));
        privilege privAnnotation = this._getter.getAnnotation(privilege.class);
        if (privAnnotation != null) {
            this.setPrivilegeId(privAnnotation.value());
        }
        this.setLink(this._getter.getAnnotation(link.class) != null);
        if (this.isLink()) {
            this.setLinkClassName(this._getter.getAnnotation(linkType.class).value());
        } else {
            this.setLinkClassName(null);
        }
        this.setLinkable(this._getter.getAnnotation(linkable.class) != null);
        this.setSecret(this._getter.getAnnotation(secret.class) != null);
        HashMap<Class, Annotation> annotationMap = Util.mapAnnotations(this._getter.getAnnotations());
        this.setCollectionType(Util.computeCollectionType(annotationMap));
    }

    @Override
    public VmodlType getType() {
        return this.getVmodlContext().getVmodlTypeMap().getVmodlType(this._getter.getReturnType());
    }

    @Override
    public Object get(Object obj) {
        try {
            return this._getter.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new InternalException(String.format("Unable to invoke getter method on object %1$s", obj), e);
        }
        catch (InvocationTargetException e) {
            throw new InternalException(String.format("Unable to invoke getter method on object %1$s", obj), e);
        }
    }

    @Override
    public void set(Object obj, Object value) {
        try {
            this._setter.invoke(obj, value);
        }
        catch (Exception e) {
            throw new InternalException(String.format("Unable to invoke setter method on object %1$s", obj), e);
        }
    }
}

