/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.vmomi.core.util;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.codec.binary.Hex;

public class SHA1HashGenerator {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final int DEFAULT_TRUNCATE_LENGTH = 8;
    private static MessageDigest _messageDigest;

    public static synchronized String generate(String value) {
        if (value == null) {
            return null;
        }
        return String.valueOf(Hex.encodeHex((byte[])_messageDigest.digest(value.getBytes(UTF_8)))).toUpperCase();
    }

    public static String generate(String value, int length) {
        if (value == null) {
            return null;
        }
        if (length < 1 || length > 40) {
            throw new IndexOutOfBoundsException("Supported lengths are from 1 to 40 inclusive.");
        }
        return SHA1HashGenerator.generate(value).substring(0, length);
    }

    public static String generateTruncated(String value) {
        return SHA1HashGenerator.generate(value, 8);
    }

    static {
        try {
            _messageDigest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Error initializing the SHA1 hashing algorithm.", e);
        }
    }
}

