/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public final class CollectionsUtil {
    private CollectionsUtil() {
    }

    public static <T> T lookup(Collection<T> col, Predicate<T> predicate) {
        Collection filter = Collections2.filter(col, predicate);
        if (filter.isEmpty()) {
            return null;
        }
        return (T)filter.iterator().next();
    }

    public static <T> Collection<T> concat(Collection<T> c1, T ... array) {
        List<Collection> asList = Arrays.asList(c1, Arrays.asList(array));
        CollectionsUtil.nullCheck(asList);
        return new CollectionImpl(asList);
    }

    public static <T> Collection<T> concat(Collection<? extends T> c1, Collection<? extends T> c2) {
        CollectionsUtil.nullCheck(c1, c2);
        List<Collection> asList = Arrays.asList(c1, c2);
        return new CollectionImpl(asList);
    }

    public static <T> Collection<T> concat(Collection<? extends T> c1, Collection<? extends T> c2, Collection<? extends T> c3) {
        CollectionsUtil.nullCheck(c1, c2, c3);
        List<Collection> asList = Arrays.asList(c1, c2, c3);
        return new CollectionImpl(asList);
    }

    public static <T> Collection<T> concat(Collection<T> ... cols) {
        CollectionsUtil.nullCheck(cols);
        List<Collection<T>> asList = Arrays.asList(cols);
        return new CollectionImpl(asList);
    }

    public static <T> Collection<T> concat(Collection<? extends Collection<? extends T>> cols) {
        CollectionsUtil.nullCheck(cols);
        return new CollectionImpl(cols);
    }

    public static <T> Iterable<Iterator<T>> getBundle(Collection<T> col, int bundleSize) {
        return new Bundle<T>(col, bundleSize);
    }

    public static <T> Iterator<Iterator<T>> getBundle(Iterator<T> iter, int bundleSize) {
        return new BundleIterator<T>(iter, bundleSize);
    }

    private static void nullCheck(Collection<?> ... cols) {
        for (Collection<?> c : cols) {
            if (c != null) continue;
            throw new NullPointerException();
        }
    }

    public static <T extends Iterable<?>> T checkForContentsNotNull(T coll) {
        if (CollectionsUtil.collContainsNullsOrIsNull(coll)) {
            throw new NullPointerException();
        }
        return coll;
    }

    public static <T extends Iterable<?>> T checkForContentsNotNull(T coll, Object errMsg) {
        if (CollectionsUtil.collContainsNullsOrIsNull(coll)) {
            throw new NullPointerException(String.valueOf(errMsg));
        }
        return coll;
    }

    public static <T extends Iterable<?>> T checkForContentsNotNull(T coll, String format, Object[] errArgs) {
        if (CollectionsUtil.collContainsNullsOrIsNull(coll)) {
            throw new NullPointerException(String.format(format, errArgs));
        }
        return coll;
    }

    static boolean collContainsNullsOrIsNull(Iterable<?> inColl) {
        if (inColl == null) {
            return true;
        }
        if (inColl instanceof Collection) {
            Collection coll = (Collection)inColl;
            try {
                return coll.contains(null);
            }
            catch (NullPointerException npe) {
                return false;
            }
        }
        Iterator<?> iIt = inColl.iterator();
        Object elmt = null;
        while (iIt.hasNext() && elmt != null) {
            elmt = iIt.next();
        }
        return elmt == null;
    }

    private static class BundleIterator<E>
    implements Iterator<Iterator<E>> {
        private final Iterator<E> _iter;
        private Iterator<E> _next;
        private final int _bundleSize;

        public BundleIterator(Iterator<E> iter, int bundleSize) {
            this._iter = iter;
            this._bundleSize = bundleSize;
        }

        @Override
        public boolean hasNext() {
            this.drainPreviousIterator();
            return this._iter.hasNext();
        }

        @Override
        public Iterator<E> next() {
            this.drainPreviousIterator();
            if (!this._iter.hasNext()) {
                throw new NoSuchElementException();
            }
            this._next = new IteratorImpl();
            return this._next;
        }

        private void drainPreviousIterator() {
            if (this._next != null) {
                while (this._next.hasNext()) {
                    this._next.next();
                }
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private class IteratorImpl
        implements Iterator<E> {
            private int _i = 0;

            private IteratorImpl() {
            }

            @Override
            public boolean hasNext() {
                return this._i < BundleIterator.this._bundleSize && BundleIterator.this._iter.hasNext();
            }

            @Override
            public E next() {
                if (this._i == BundleIterator.this._bundleSize) {
                    throw new NoSuchElementException();
                }
                Object result = BundleIterator.this._iter.next();
                ++this._i;
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    static class Bundle<E>
    implements Iterable<Iterator<E>> {
        private final Collection<E> _col;
        private final int _bundleSize;

        Bundle(Collection<E> col, int bundleSize) {
            if (bundleSize <= 0) {
                throw new IllegalArgumentException("Bundle size must be greater than 0.");
            }
            if (col == null) {
                throw new IllegalArgumentException("Null collection is not allowed");
            }
            this._col = col;
            this._bundleSize = bundleSize;
        }

        @Override
        public Iterator<Iterator<E>> iterator() {
            return new BundleIterator<E>(this._col.iterator(), this._bundleSize);
        }
    }

    private static class CollectionImpl<E>
    extends AbstractCollection<E> {
        final Iterable<E> _iterable;
        final Collection<? extends Collection<? extends E>> _cols;

        private CollectionImpl(Collection<? extends Collection<? extends E>> cols) {
            this._iterable = Iterables.unmodifiableIterable((Iterable)Iterables.concat(cols));
            this._cols = cols;
        }

        @Override
        public int size() {
            int size = 0;
            for (Collection<E> c : this._cols) {
                size += c.size();
            }
            return size;
        }

        @Override
        public Iterator<E> iterator() {
            return this._iterable.iterator();
        }
    }
}

