/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cis.core.util;

import com.vmware.cis.core.Permission;
import com.vmware.cis.core.Principal;
import com.vmware.cis.core.SimplePrincipal;
import com.vmware.vim.binding.dataservice.accesscontrol.AccessControl;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vim.vmomi.core.Future;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public final class Helper {
    private static final Log _log = LogFactory.getLog(Helper.class);
    private static final String GUID_BASE = UUID.randomUUID().toString();
    private static final AtomicInteger NEXT = new AtomicInteger();
    private static final SecureRandom _random = new SecureRandom();
    private static final String CL_Lib_Resource_Prefix = "urn:vapi:com.vmware.content.Library";
    private static final String CL_Lib_Doc_Suffix = ":com.vmware.content.library_model";
    private static final String CL_Item_Resource_Prefix = "urn:vapi:com.vmware.content.library.Item";
    private static final String CL_Item_Doc_Suffix = ":com.vmware.content.library.item_model";

    private Helper() {
        assert (false);
    }

    public static String getNextUuid() {
        return GUID_BASE + NEXT.getAndIncrement();
    }

    public static <T> Set<T> getSet(T ... a) {
        if (a == null || a.length == 0) {
            return Collections.emptySet();
        }
        if (a.length == 1) {
            return Collections.singleton(a[0]);
        }
        HashSet result = new HashSet();
        Collections.addAll(result, a);
        return result;
    }

    public static <T> Set<String> getIdSet(Collection<T> c, GetId<T> getId) {
        HashSet<String> result = new HashSet<String>();
        for (T t : c) {
            result.add(getId.id(t));
        }
        return result;
    }

    public static <T> Set<String> getIdSet(T[] a, GetId<T> getId) {
        HashSet<String> result = new HashSet<String>();
        for (T t : a) {
            result.add(getId.id(t));
        }
        return result;
    }

    public static void setSystemError(Future<?> future, Throwable e, Log log) {
        future.setException((Exception)new SystemError());
        log.error((Object)"Store Exception ", e);
    }

    public static String encode(URI uri) {
        return Helper.encode(uri.toString());
    }

    public static String encode(String uri) {
        if (uri == null) {
            return null;
        }
        try {
            return URLEncoder.encode(uri, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String decode(String id) {
        if (id == null) {
            return null;
        }
        try {
            return URLDecoder.decode(id, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static Document getAsDoc(InputStream stream) throws TransformerException {
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", "yes");
        DOMResult result = new DOMResult();
        t.transform(new StreamSource(stream), result);
        return (Document)result.getNode();
    }

    public static long nextLong() {
        return _random.nextLong();
    }

    public static int nextInt() {
        return _random.nextInt();
    }

    public static List<Permission> getPossiblePermissionCollection(Collection<AccessControl> acl, String encodedDocId) {
        if (acl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList permissions = new ArrayList();
        for (AccessControl ac : acl) {
            try {
                permissions.add(Helper.newPermission(encodedDocId, ac));
            }
            catch (Throwable t) {
                _log.warn((Object)("Unable to parse permission from access control " + ac), t);
            }
        }
        return permissions.isEmpty() ? Collections.emptyList() : permissions;
    }

    public static List<Permission> getPermissionCollection(Collection<AccessControl> acl, String encodedDocId) {
        if (acl.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList permissions = new ArrayList();
        for (AccessControl ac : acl) {
            permissions.add(Helper.newPermission(encodedDocId, ac));
        }
        return permissions.isEmpty() ? Collections.emptyList() : permissions;
    }

    public static Permission newPermission(String encodedDocId, AccessControl ac) {
        com.vmware.vim.binding.dataservice.accesscontrol.Principal principal = ac.getPrincipal();
        SimplePrincipal simplePrincipal = new SimplePrincipal(principal.getName(), principal.isGroup());
        Permission result = new Permission(encodedDocId, (Principal)simplePrincipal, ac.getRoles(), ac.isPropagate(), ac.getVersion());
        return result;
    }

    public static ThreadFactory newDaemonThreadFactory(final String groupName) {
        return new ThreadFactory(){
            private final AtomicInteger _count = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                ThreadGroup tg = new ThreadGroup(groupName);
                Thread t = new Thread(tg, r);
                t.setDaemon(true);
                t.setName(groupName + "-" + this._count.getAndIncrement());
                return t;
            }
        };
    }

    private static boolean hasCLPrefix(String id) {
        return id.startsWith(CL_Lib_Resource_Prefix) || id.startsWith(CL_Item_Resource_Prefix);
    }

    private static boolean hasCLDocSuffix(String id) {
        return id.endsWith(CL_Lib_Doc_Suffix) || id.endsWith(CL_Item_Doc_Suffix);
    }

    private static boolean isCLDocId(String id) {
        return Helper.hasCLPrefix(id) && Helper.hasCLDocSuffix(id);
    }

    private static boolean isCLResourceId(String id) {
        return Helper.hasCLPrefix(id) && !Helper.hasCLDocSuffix(id);
    }

    public static String docIdtoResourceId(String id) {
        String resourceId = id.startsWith(CL_Lib_Resource_Prefix) ? id.substring(0, id.length() - CL_Lib_Doc_Suffix.length()) : (id.startsWith(CL_Item_Resource_Prefix) ? id.substring(0, id.length() - CL_Item_Doc_Suffix.length()) : id);
        if (_log.isTraceEnabled() && !id.equals(resourceId)) {
            _log.trace((Object)("Translated doc id: " + id + " to resource id: " + resourceId));
        }
        return resourceId;
    }

    public static URI docIdtoResourceId(URI idUri) throws Exception {
        String docId = idUri.toASCIIString();
        if (!Helper.isCLDocId(docId)) {
            return idUri;
        }
        String resourceId = Helper.docIdtoResourceId(docId);
        return new URI(resourceId);
    }

    public static String resourceIdToDocId(String id) {
        String docId = id.startsWith(CL_Lib_Resource_Prefix) ? id + CL_Lib_Doc_Suffix : (id.startsWith(CL_Item_Resource_Prefix) ? id + CL_Item_Doc_Suffix : id);
        if (_log.isTraceEnabled() && !id.equals(docId)) {
            _log.trace((Object)("Translated resource id: " + id + " to doc id: " + docId));
        }
        return docId;
    }

    public static URI resourceIdToDocId(URI idUri) throws Exception {
        String resourceId = idUri.toASCIIString();
        if (!Helper.isCLResourceId(resourceId)) {
            return idUri;
        }
        String docId = Helper.resourceIdToDocId(resourceId);
        return new URI(docId);
    }

    public static String removeSuffix(String original, String suffix) {
        if (!original.endsWith(suffix)) {
            return original;
        }
        return original.substring(0, original.length() - suffix.length());
    }

    public static String replacePrefix(String original, String oldPrefix, String newPrefix) {
        if (!original.startsWith(oldPrefix)) {
            return original;
        }
        if (oldPrefix.equals(newPrefix)) {
            return original;
        }
        return original.replaceFirst(oldPrefix, newPrefix);
    }

    public static interface GetId<T> {
        public String id(T var1);
    }
}

