/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core;

import com.vmware.vim.query.core.Principal;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class Permission {
    private final String _objectId;
    private final Principal _principal;
    private final Set<Long> _roleIds;
    private final boolean _propagate;
    private final long _version;

    public Permission(String objectId, Principal principal, long[] roleIds, boolean propagate, long version) {
        this._objectId = objectId;
        this._principal = principal;
        HashSet<Long> set = new HashSet<Long>();
        if (roleIds != null) {
            for (long id : roleIds) {
                set.add(id);
            }
        }
        this._roleIds = Collections.unmodifiableSet(set);
        this._propagate = propagate;
        this._version = version;
    }

    public Permission(String objectId, Principal principal, Collection<Long> roleIds, boolean propagate, long version) {
        this._objectId = objectId;
        this._principal = principal;
        HashSet<Long> set = new HashSet<Long>(roleIds);
        this._roleIds = Collections.unmodifiableSet(set);
        this._propagate = propagate;
        this._version = version;
    }

    public String getObjectId() {
        return this._objectId;
    }

    public Principal getPrincipal() {
        return this._principal;
    }

    public Set<Long> getRoleIds() {
        return this._roleIds;
    }

    public boolean getPropagate() {
        return this._propagate;
    }

    public long getVersion() {
        return this._version;
    }

    public String toString() {
        return "\nPermission on: obj:" + this._objectId + " principal:" + this._principal.getName() + " roleids: " + this._roleIds + " propagate: " + this._propagate;
    }
}

