/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core;

import java.net.URI;

public class SourceVersion {
    private final String _providerID;
    private final URI _qsId;
    private final long _sourceVersion;

    public SourceVersion(String providerId, URI qsId, long sourceVersion) {
        if (providerId == null) {
            throw new IllegalArgumentException("providerID unspecified");
        }
        if (qsId == null) {
            throw new IllegalArgumentException("qsId unspecified");
        }
        this._providerID = providerId;
        this._qsId = qsId;
        this._sourceVersion = sourceVersion;
    }

    public SourceVersion(String versionString) {
        String[] ver = versionString.split(",");
        if (ver.length != 3) {
            throw new IllegalArgumentException("SourceVersion string:" + versionString + " unsupported");
        }
        this._qsId = URI.create(ver[0]);
        this._sourceVersion = Long.parseLong(ver[1]);
        this._providerID = ver[2];
    }

    public String getProviderID() {
        return this._providerID;
    }

    public URI getId() {
        return this._qsId;
    }

    public long getSourceVersion() {
        return this._sourceVersion;
    }

    public String toString() {
        return this._qsId + "," + this._sourceVersion + "," + this._providerID;
    }
}

