/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim.query.core.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class KeyBasedSet<T>
extends AbstractSet<T>
implements Set<T>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected final GetKey<T> _getKey;
    protected final Map<Object, T> _map;
    protected final Class<T> _cls;

    public static <T> KeyBasedSet<T> getImmuableCopy(Class<T> cls, GetKey<T> equalsAndHashProvider, Map<?, T> map) {
        return new KeyBasedSet<T>(cls, equalsAndHashProvider, map);
    }

    public KeyBasedSet(Class<T> cls) {
        this(cls, new GetKey<T>(){
            private static final long serialVersionUID = 1L;

            @Override
            public Object key(T k) {
                return k;
            }
        });
    }

    public KeyBasedSet(Class<T> cls, GetKey<T> equalsAndHashProvider) {
        this._getKey = equalsAndHashProvider;
        this._map = new HashMap<Object, T>();
        this._cls = cls;
    }

    public KeyBasedSet(Class<T> cls, GetKey<T> equalsAndHashProvider, T ... arr) {
        this._getKey = equalsAndHashProvider;
        this._map = new HashMap<Object, T>();
        this._cls = cls;
        this.addAll(arr);
    }

    public KeyBasedSet(Class<T> cls, GetKey<T> equalsAndHashProvider, Map<Object, T> map) {
        this._getKey = equalsAndHashProvider;
        this._map = map;
        this._cls = cls;
    }

    protected void isInValidObject(Object obj) {
        if (!this._cls.isInstance(obj)) {
            throw new ClassCastException("Object of type " + this._cls.getName() + " are allowed in this collection.");
        }
    }

    @Override
    public Iterator<T> iterator() {
        return this._map.values().iterator();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.isInValidObject(o);
        return this._map.containsKey(this._getKey.key(o));
    }

    @Override
    public boolean add(T e) {
        Object key = this._getKey.key(e);
        T oldValue = this._map.put(key, e);
        if (oldValue == null) {
            return true;
        }
        if (oldValue.equals(e)) {
            this._map.put(key, oldValue);
            return false;
        }
        return true;
    }

    @Override
    public boolean remove(Object o) {
        this.isInValidObject(o);
        return this._map.remove(this._getKey.key(o)) != null;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public boolean containsKey(Object key) {
        return this.containsAllKeys(Collections.singletonList(key));
    }

    public boolean containsAllKeys(Collection<?> keys) {
        return this._map.keySet().containsAll(keys);
    }

    public boolean removeKey(Object id) {
        return this.removeAllKeys(Collections.singletonList(id));
    }

    public boolean removeAllKeys(Collection<?> keys) {
        return this._map.keySet().removeAll(keys);
    }

    public boolean retailAllIds(Collection<?> keys) {
        return this._map.keySet().retainAll(keys);
    }

    public T getValueForKey(Object id) {
        return this._map.get(id);
    }

    public T get(T t) {
        return this._map.get(this._getKey.key(t));
    }

    public boolean containsAll(T ... a) {
        if (a == null) {
            return true;
        }
        for (T t : a) {
            if (this.contains(t)) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(T ... a) {
        if (a == null || a.length == 0) {
            return false;
        }
        boolean modified = false;
        for (T t : a) {
            if (!this.add(t)) continue;
            modified = true;
        }
        return modified;
    }

    public static interface GetKey<K>
    extends Serializable {
        public Object key(K var1);
    }
}

