/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vcaddons.impl;

import com.vmware.vim.binding.vim.Extension;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.util.XMLUtil;
import com.vmware.vise.vim.vcaddons.data.ESXiDumpCollectorConfiguration;
import com.vmware.vsphere.client.vcaddons.util.Util;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ESXiDumpCollectorPropertyProviderImpl
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(ESXiDumpCollectorPropertyProviderImpl.class);

    @type(value="Folder")
    public ESXiDumpCollectorConfiguration getESXiDumpCollectorConfiguration(ManagedObjectReference objRef) {
        String modifiedURL = null;
        String serverGuid = objRef.getServerGuid();
        Extension.ServerInfo si = Util.getServerInfo(serverGuid, "com.vmware.netdump");
        if (si == null) {
            _logger.error((Object)("Missing com.vmware.vim.viClientScripts serverInfo in ESXiDumpCollector extension for server " + serverGuid));
            return null;
        }
        modifiedURL = si.getUrl().replace("extension.xml", "");
        try {
            URL EDCUrl = new URL(modifiedURL);
            String response = Util.executeRequest(EDCUrl, null, null, null);
            return this.parseESXiDumpCollectorConfiguration(response);
        }
        catch (MalformedURLException e) {
            _logger.error((Object)e);
            return null;
        }
    }

    @type(value="Folder")
    public Boolean getEsxiDumpCollectorExtensionInstalled(ManagedObjectReference serverObj) {
        String serverGuid = serverObj.getServerGuid();
        return Util.isExtensionInstalled(serverGuid, "com.vmware.netdump");
    }

    private ESXiDumpCollectorConfiguration parseESXiDumpCollectorConfiguration(String esxDumpCollectorConfigXmlStr) {
        ESXiDumpCollectorConfiguration dumpCollectorConfig = new ESXiDumpCollectorConfiguration();
        Document xmlDocument = null;
        xmlDocument = XMLUtil.parseXml((String)esxDumpCollectorConfigXmlStr);
        if (xmlDocument == null) {
            return null;
        }
        Element root = xmlDocument.getDocumentElement();
        NodeList children = root.getChildNodes();
        ArrayList<KeyValue> propertyList = new ArrayList<KeyValue>();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals("property")) continue;
            String propertyName = XMLUtil.getChildTagValue((Node)child, (String)"name");
            String propertyValue = XMLUtil.getChildTagValue((Node)child, (String)"value");
            KeyValue ecp = new KeyValue();
            ecp.key = propertyName;
            ecp.value = propertyValue;
            propertyList.add(ecp);
        }
        dumpCollectorConfig.settings = propertyList.toArray(new KeyValue[propertyList.size()]);
        return dumpCollectorConfig;
    }
}

